/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';

    public static void performTypingAction(Editor editor, char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        if (c == '\uffff') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorBackSpace");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else if (c == '\ufffe') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorCompleteStatement");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else if (c == '\ufffd') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorSplitLine");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else if (c == '\n') {
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorEnter");
            actionHandler.execute(editor, DataManager.getInstance().getDataContext());
        } else {
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, DataManager.getInstance().getDataContext());
        }
    }

    public static void performReferenceCopy(DataContext dataContext) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction("CopyReference");
        AnActionEvent event = new AnActionEvent(null, dataContext, "", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
        action.update(event);
        junit.framework.Assert.assertTrue((boolean)event.getPresentation().isEnabled());
        action.actionPerformed(event);
    }

    public static void performPaste(Editor editor) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorPaste");
        actionHandler.execute(editor, DataManager.getInstance().getDataContext());
    }

    public static List<IElementType> getAllTokens(EditorHighlighter highlighter) {
        ArrayList<IElementType> tokens = new ArrayList<IElementType>();
        HighlighterIterator iterator = highlighter.createIterator(0);
        while (!iterator.atEnd()) {
            tokens.add(iterator.getTokenType());
            iterator.advance();
        }
        return tokens;
    }

    public static int getCaretPosition(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/EditorTestUtil", "getCaretPosition"));
        }
        return EditorTestUtil.getCaretAndSelectionPosition(content)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String content) {
        String visualOffsetString;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/EditorTestUtil", "getCaretAndSelectionPosition"));
        }
        int caretPosInSourceFile = content.indexOf(CARET_TAG_PREFIX);
        int caretEndInSourceFile = content.indexOf(">", caretPosInSourceFile);
        int caretLength = caretEndInSourceFile - caretPosInSourceFile;
        int visualColumnOffset = 0;
        if (caretPosInSourceFile >= 0 && (visualOffsetString = content.substring(caretPosInSourceFile + CARET_TAG_PREFIX.length(), caretEndInSourceFile)).length() > 1) {
            visualColumnOffset = Integer.parseInt(visualOffsetString.substring(1));
        }
        int selectionStartInSourceFile = content.indexOf(SELECTION_START_TAG);
        int selectionEndInSourceFile = content.indexOf(SELECTION_END_TAG);
        if (selectionStartInSourceFile >= 0) {
            if (caretPosInSourceFile >= 0) {
                if (caretPosInSourceFile < selectionStartInSourceFile) {
                    selectionStartInSourceFile -= caretLength;
                    selectionEndInSourceFile -= caretLength;
                } else {
                    caretPosInSourceFile = caretPosInSourceFile < selectionEndInSourceFile ? (caretPosInSourceFile -= SELECTION_START_TAG.length()) : (caretPosInSourceFile -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            selectionEndInSourceFile -= SELECTION_START_TAG.length();
        }
        return new int[]{caretPosInSourceFile, visualColumnOffset, selectionStartInSourceFile, selectionEndInSourceFile};
    }

    public static boolean configureSoftWraps(Editor editor, int charCountToWrapAt) {
        int charWidthInPixels = 7;
        return EditorTestUtil.configureSoftWraps(editor, (charCountToWrapAt + 1) * charWidthInPixels + 1, charWidthInPixels);
    }

    public static boolean configureSoftWraps(Editor editor, final int visibleWidth, final int charWidthInPixels) {
        editor.getSettings().setUseSoftWraps(true);
        SoftWrapModelImpl model = (SoftWrapModelImpl)editor.getSoftWrapModel();
        model.reinitSettings();
        SoftWrapApplianceManager applianceManager = model.getApplianceManager();
        applianceManager.setWidthProvider(new SoftWrapApplianceManager.VisibleAreaWidthProvider(){

            @Override
            public int getVisibleAreaWidth() {
                return visibleWidth;
            }
        });
        applianceManager.setRepresentationHelper(new DefaultEditorTextRepresentationHelper(editor){

            @Override
            public int charWidth(char c, int fontType) {
                return charWidthInPixels;
            }
        });
        applianceManager.registerSoftWrapIfNecessary();
        return !model.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor, int widthInChars, int heightInChars) {
        Dimension size = new Dimension(widthInChars * EditorUtil.getSpaceWidth(0, editor), heightInChars * editor.getLineHeight());
        ((EditorEx)editor).getScrollPane().getViewport().setExtentSize(size);
    }

    public static CaretAndSelectionState extractCaretAndSelectionMarkers(Document document) {
        return EditorTestUtil.extractCaretAndSelectionMarkers(document, true);
    }

    public static CaretAndSelectionState extractCaretAndSelectionMarkers(final Document document, final boolean processBlockSelection) {
        return (CaretAndSelectionState)new WriteCommandAction<CaretAndSelectionState>(null, new PsiFile[0]){

            public void run(@NotNull Result<CaretAndSelectionState> actionResult) {
                if (actionResult == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/EditorTestUtil$3", "run"));
                }
                CaretAndSelectionState result = new CaretAndSelectionState();
                String fileText = document.getText();
                RangeMarker blockSelectionStartMarker = null;
                RangeMarker blockSelectionEndMarker = null;
                if (processBlockSelection) {
                    int blockSelectionEnd;
                    int blockSelectionStart = fileText.indexOf(EditorTestUtil.BLOCK_SELECTION_START_TAG);
                    if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(EditorTestUtil.BLOCK_SELECTION_END_TAG))) < 0) {
                        throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
                    }
                    if (blockSelectionStart >= 0) {
                        blockSelectionStartMarker = document.createRangeMarker(blockSelectionStart, blockSelectionStart);
                        blockSelectionEndMarker = document.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                        document.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + EditorTestUtil.BLOCK_SELECTION_START_TAG.length());
                        document.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + EditorTestUtil.BLOCK_SELECTION_END_TAG.length());
                    }
                }
                boolean multiCaret = StringUtil.getOccurrenceCount((String)document.getText(), (String)EditorTestUtil.CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document.getText(), (String)EditorTestUtil.SELECTION_START_TAG) > 1;
                int pos = 0;
                while (pos < document.getTextLength()) {
                    RangeMarker selEndMarker;
                    int selEndIndex;
                    fileText = document.getText();
                    int caretIndex = fileText.indexOf(EditorTestUtil.CARET_TAG, pos);
                    int selStartIndex = fileText.indexOf(EditorTestUtil.SELECTION_START_TAG, pos);
                    if ((selStartIndex ^ (selEndIndex = fileText.indexOf(EditorTestUtil.SELECTION_END_TAG, pos))) < 0) {
                        selStartIndex = -1;
                        selEndIndex = -1;
                    }
                    if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                        throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
                    }
                    if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
                    if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                        selStartIndex = -1;
                        selEndIndex = -1;
                    }
                    if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                        caretIndex = -1;
                    }
                    RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
                    RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
                    RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
                    if (caretMarker != null) {
                        document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + EditorTestUtil.CARET_TAG.length());
                    }
                    if (selStartMarker != null) {
                        document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + EditorTestUtil.SELECTION_START_TAG.length());
                    }
                    if (selEndMarker != null) {
                        document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + EditorTestUtil.SELECTION_END_TAG.length());
                    }
                    LogicalPosition caretPosition = null;
                    if (caretMarker != null) {
                        int line = document.getLineNumber(caretMarker.getStartOffset());
                        int column = caretMarker.getStartOffset() - document.getLineStartOffset(line);
                        caretPosition = new LogicalPosition(line, column);
                    }
                    result.carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
                    pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
                }
                if (result.carets.isEmpty()) {
                    result.carets.add(new CaretInfo(null, null));
                }
                if (blockSelectionStartMarker != null) {
                    result.blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
                }
                actionResult.setResult((Object)result);
            }
        }.execute().getResultObject();
    }

    public static void setCaretsAndSelection(Editor editor, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor.getCaretModel();
        if (caretModel.supportsMultipleCarets()) {
            ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets.size());
            for (CaretInfo caret : caretsState.carets) {
                states.add(new CaretState(caret.position == null ? null : editor.offsetToLogicalPosition(caret.getCaretOffset(editor.getDocument())), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getEndOffset())));
            }
            caretModel.setCaretsAndSelections(states);
        } else {
            Assert.assertEquals((String)"Multiple carets are not supported by the model", (long)1L, (long)caretsState.carets.size());
            CaretInfo caret = caretsState.carets.get(0);
            if (caret.position != null) {
                caretModel.moveToOffset(caret.getCaretOffset(editor.getDocument()));
            }
            if (caret.selection != null) {
                editor.getSelectionModel().setSelection(caret.selection.getStartOffset(), caret.selection.getEndOffset());
            } else {
                editor.getSelectionModel().removeSelection();
            }
        }
        if (caretsState.blockSelection != null) {
            editor.getSelectionModel().setBlockSelection(editor.offsetToLogicalPosition(caretsState.blockSelection.getStartOffset()), editor.offsetToLogicalPosition(caretsState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor, caretState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState, String message) {
        boolean hasChecks = false;
        for (int i = 0; i < caretState.carets.size(); ++i) {
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position == null && expected.selection == null) continue;
            hasChecks = true;
            break;
        }
        if (!hasChecks) {
            return;
        }
        String messageSuffix = message == null ? "" : message + ": ";
        CaretModel caretModel = editor.getCaretModel();
        ArrayList allCarets = new ArrayList(caretModel.getAllCarets());
        Assert.assertEquals((String)(messageSuffix + " Unexpected number of carets"), (long)caretState.carets.size(), (long)allCarets.size());
        for (int i = 0; i < caretState.carets.size(); ++i) {
            String caretDescription = caretState.carets.size() == 1 ? "" : "caret " + (i + 1) + "/" + caretState.carets.size() + " ";
            Caret currentCaret = (Caret)allCarets.get(i);
            int actualCaretLine = editor.getDocument().getLineNumber(currentCaret.getOffset());
            int actualCaretColumn = currentCaret.getOffset() - editor.getDocument().getLineStartOffset(actualCaretLine);
            LogicalPosition actualCaretPosition = new LogicalPosition(actualCaretLine, actualCaretColumn);
            int[] selectionStarts = editor.getSelectionModel().getBlockSelectionStarts();
            int[] selectionEnds = editor.getSelectionModel().getBlockSelectionEnds();
            int selectionStart = editor.getSelectionModel().hasBlockSelection() ? selectionStarts[selectionStarts.length - 1] : currentCaret.getSelectionStart();
            int selectionEnd = editor.getSelectionModel().hasBlockSelection() ? selectionEnds[selectionEnds.length - 1] : currentCaret.getSelectionEnd();
            LogicalPosition actualSelectionStart = editor.offsetToLogicalPosition(selectionStart);
            LogicalPosition actualSelectionEnd = editor.offsetToLogicalPosition(selectionEnd);
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position != null) {
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected caret position"), (Object)expected.position, (Object)actualCaretPosition);
            }
            if (expected.selection != null) {
                LogicalPosition expectedSelectionStart = editor.offsetToLogicalPosition(expected.selection.getStartOffset());
                LogicalPosition expectedSelectionEnd = editor.offsetToLogicalPosition(expected.selection.getEndOffset());
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection start"), (Object)expectedSelectionStart, (Object)actualSelectionStart);
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection end"), (Object)expectedSelectionEnd, (Object)actualSelectionEnd);
                continue;
            }
            Assert.assertFalse((String)(messageSuffix + caretDescription + "should has no selection, but was: (" + actualSelectionStart + ", " + actualSelectionEnd + ")"), (boolean)currentCaret.hasSelection());
        }
    }

    public static void enableMultipleCarets() {
        Registry.get((String)"editor.allow.multiple.carets").setValue(true);
    }

    public static void disableMultipleCarets() {
        Registry.get((String)"editor.allow.multiple.carets").setValue(false);
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document) {
            return document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets = new ArrayList<CaretInfo>();
        @Nullable
        public TextRange blockSelection;
    }
}

