/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import org.jetbrains.annotations.NotNull;

public abstract class ActionTestCase
extends UsefulTestCase {
    public static final String CARET_TAG_REPLACE_REGEX = EditorTestUtil.CARET_TAG_PREFIX + "(\\+\\d+)?>";
    protected CodeInsightTestFixture myFixture;

    protected abstract FileType getFileType();

    protected abstract String getTestDataPath();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder<IdeaProjectTestFixture> fixtureBuilder = factory.createLightFixtureBuilder(null);
        IdeaProjectTestFixture fixture = fixtureBuilder.getFixture();
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, new LightTempDirTestFixtureImpl(true));
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFixture.tearDown();
        this.myFixture = null;
        super.tearDown();
    }

    protected void doAction(@NotNull String before, @NotNull String expected, @NotNull Runnable action) {
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/ActionTestCase", "doAction"));
        }
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/ActionTestCase", "doAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/testFramework/ActionTestCase", "doAction"));
        }
        int[] caretAndSelectionPositionInSourceFile = EditorTestUtil.getCaretAndSelectionPosition(before);
        int[] caretAndSelectionPositionInExpectedFile = EditorTestUtil.getCaretAndSelectionPosition(expected);
        String sourceFinal = before.replaceAll(CARET_TAG_REPLACE_REGEX, "").replace("<selection>", "").replace("</selection>", "");
        String expectedFinal = expected.replaceAll(CARET_TAG_REPLACE_REGEX, "").replace("<selection>", "").replace("</selection>", "");
        PsiFile file = this.myFixture.configureByText(this.getFileType(), sourceFinal);
        this.myFixture.getEditor().getSettings().setVirtualSpace(true);
        if (caretAndSelectionPositionInSourceFile[0] >= 0) {
            CaretModel caretModel = this.myFixture.getEditor().getCaretModel();
            caretModel.moveToOffset(caretAndSelectionPositionInSourceFile[0]);
            if (caretAndSelectionPositionInSourceFile[1] != 0) {
                int line = caretModel.getVisualPosition().getLine();
                int column = caretModel.getVisualPosition().getColumn();
                caretModel.moveToVisualPosition(new VisualPosition(line, column + caretAndSelectionPositionInSourceFile[1]));
            }
        }
        if (caretAndSelectionPositionInSourceFile[2] >= 0) {
            this.myFixture.getEditor().getSelectionModel().setSelection(caretAndSelectionPositionInSourceFile[2], caretAndSelectionPositionInSourceFile[3]);
        }
        ApplicationManager.getApplication().runWriteAction(action);
        if (caretAndSelectionPositionInExpectedFile[0] >= 0) {
            ActionTestCase.assertEquals((int)caretAndSelectionPositionInExpectedFile[0], (int)this.myFixture.getCaretOffset());
            if (caretAndSelectionPositionInExpectedFile[1] != 0) {
                ActionTestCase.assertEquals((int)caretAndSelectionPositionInExpectedFile[1], (int)this.myFixture.getEditor().getCaretModel().getVisualPosition().getColumn());
            }
        }
        if (caretAndSelectionPositionInExpectedFile[2] >= 0) {
            ActionTestCase.assertEquals((int)caretAndSelectionPositionInExpectedFile[2], (int)this.myFixture.getEditor().getSelectionModel().getSelectionStart());
            ActionTestCase.assertEquals((int)caretAndSelectionPositionInExpectedFile[3], (int)this.myFixture.getEditor().getSelectionModel().getSelectionEnd());
        }
        ActionTestCase.assertEquals((String)expectedFinal, (String)this.myFixture.getDocument(file).getText());
    }
}

