/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SPIFileType INSTANCE = new SPIFileType();

    private SPIFileType() {
        super((Language)SPILanguage.INSTANCE);
    }

    @Override
    public boolean isMyFileType(VirtualFile file) {
        VirtualFile gParent;
        VirtualFile parent = file.getParent();
        if (parent != null && "services".equals(parent.getName()) && (gParent = parent.getParent()) != null && "META-INF".equals(gParent.getName())) {
            String fileName = file.getName();
            for (Object condition : Extensions.getExtensions((String)"com.intellij.vetoSPICondition")) {
                if (!((Condition)condition).value((Object)fileName)) continue;
                return false;
            }
            return FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN;
        }
        return false;
    }

    @NotNull
    public String getName() {
        if ("SPI" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getName"));
        }
        return "SPI";
    }

    @NotNull
    public String getDescription() {
        if ("Service Provider Interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getDescription"));
        }
        return "Service Provider Interface";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getDefaultExtension"));
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spi/SPIFileType", "getCharset"));
        }
        return "UTF-8";
    }
}

