/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.UnitBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Encoder {
    private final Alphabet alphabet;
    private static final int offset = 0;
    static final UnitBitSet WORD_OF_ENTIRELY_UNKNOWN_LETTERS = new UnitBitSet(new byte[1], new Alphabet());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.compress");

    public Encoder() {
        this.alphabet = new Alphabet();
    }

    public Encoder(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Nullable
    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) {
        if (letters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/compress/Encoder", "encode"));
        }
        if (64 <= letters.length() + 0) {
            return null;
        }
        int unknownLetters = 0;
        byte[] indices = new byte[letters.length()];
        for (int i = 0; i < letters.length(); ++i) {
            char letter = letters.charAt(i);
            int index = this.alphabet.getIndex(letter, force);
            if (index < 0) {
                ++unknownLetters;
                continue;
            }
            indices[i] = (byte)index;
        }
        if (unknownLetters == letters.length()) {
            return WORD_OF_ENTIRELY_UNKNOWN_LETTERS;
        }
        if (unknownLetters > 0) {
            return null;
        }
        return new UnitBitSet(indices, this.alphabet);
    }

    @NotNull
    public String decode(@NotNull byte[] compressed) {
        if (compressed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/compress/Encoder", "decode"));
        }
        String string = UnitBitSet.decode(compressed, this.alphabet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/Encoder", "decode"));
        }
        return string;
    }

    public int getFirstLetterIndex(byte firstPackedByte) {
        return UnitBitSet.getFirstLetterIndex(firstPackedByte, this.alphabet);
    }
}

