/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import org.jetbrains.annotations.NotNull;

public final class Alphabet {
    private final char[] letters;
    private int lastIndexUsed;
    private static final int MAX_INDEX = 255;

    public char getLetter(int position) {
        return this.letters[position];
    }

    public int getIndex(char letter, boolean forceAdd) {
        return this.getNextIndex(0, letter, forceAdd);
    }

    public int getNextIndex(int startFrom, char letter, boolean forceAdd) {
        for (int i = startFrom; i <= this.lastIndexUsed; ++i) {
            if (i == this.letters.length) {
                return -1;
            }
            if (this.letters[i] == '\u0000' || this.letters[i] != letter) continue;
            return i;
        }
        if (!forceAdd) {
            return -1;
        }
        return this.add(letter);
    }

    public int getLastIndexUsed() {
        return this.lastIndexUsed;
    }

    public int add(char c) {
        if (this.lastIndexUsed >= this.letters.length - 1) {
            return -1;
        }
        ++this.lastIndexUsed;
        this.letters[this.lastIndexUsed] = c;
        return this.lastIndexUsed;
    }

    Alphabet() {
        this(255);
    }

    Alphabet(int maxIndex) {
        this.lastIndexUsed = 0;
        assert (maxIndex <= 255) : "alphabet is too long";
        this.letters = new char[maxIndex];
    }

    Alphabet(@NotNull CharSequence alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/compress/Alphabet", "<init>"));
        }
        this(alphabet.length() + 1);
        for (int i = 0; i < alphabet.length(); ++i) {
            this.add(alphabet.charAt(i));
        }
    }
}

