/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.ProjectTopics;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public abstract class CloudSupportConfigurableBase<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, SR extends CloudMultiSourceServerRuntimeInstance<DC, ?, ?, ?>>
extends FrameworkSupportConfigurable {
    private final Project myModelProject;
    private boolean myInitialized = false;

    public CloudSupportConfigurableBase(FrameworkSupportModel frameworkSupportModel) {
        this.myModelProject = frameworkSupportModel.getProject();
    }

    public void dispose() {
        Disposer.dispose(this.getAccountSelectionEditor());
    }

    protected void initUI() {
        this.getAccountSelectionEditor().initUI();
    }

    protected void reloadExistingApplications() {
        Collection deployments = (Collection)new ConnectionTask<Collection<Deployment>>("Loading existing applications list"){

            @Override
            protected void run(final ServerConnection<DC> connection, final Semaphore semaphore, final AtomicReference<Collection<Deployment>> result) {
                connection.connectIfNeeded(new ServerConnector.ConnectionCallback<DC>(){

                    public void connected(@NotNull ServerRuntimeInstance<DC> serverRuntimeInstance) {
                        if (serverRuntimeInstance == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudSupportConfigurableBase$1$1", "connected"));
                        }
                        connection.computeDeployments(new Runnable(){

                            @Override
                            public void run() {
                                result.set(connection.getDeployments());
                                semaphore.up();
                            }
                        });
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudSupportConfigurableBase$1$1", "errorOccurred"));
                        }
                        this.runtimeErrorOccurred(errorMessage);
                        semaphore.up();
                    }
                });
            }

            @Override
            protected Collection<Deployment> run(SR serverRuntimeInstance) throws ServerRuntimeException {
                return null;
            }
        }.performSync();
        if (deployments == null) {
            return;
        }
        JComboBox existingComboBox = this.getExistingComboBox();
        existingComboBox.removeAllItems();
        for (Deployment deployment : deployments) {
            existingComboBox.addItem(deployment.getName());
        }
    }

    public void onFrameworkSelectionChanged(boolean selected) {
        if (selected && !this.myInitialized) {
            this.myInitialized = true;
            this.initUI();
            this.updateApplicationUI();
        }
    }

    protected void showMessage(String message, MessageType messageType) {
        this.getNotifier().showMessage(message, messageType);
    }

    protected Project getProject() {
        return this.myModelProject;
    }

    protected RemoteServer<SC> getServer() {
        return this.getAccountSelectionEditor().getServer();
    }

    protected void runOnModuleAdded(final Module module, final Runnable runnable) {
        if (this.myModelProject == null) {
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(runnable);
        } else {
            MessageBusConnection connection = this.myModelProject.getMessageBus().connect((Disposable)this.myModelProject);
            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

                public void moduleAdded(Project project, Module addedModule) {
                    if (addedModule == module) {
                        runnable.run();
                    }
                }
            });
        }
    }

    protected abstract CloudAccountSelectionEditor<SC, DC, ?> getAccountSelectionEditor();

    protected abstract JComboBox getExistingComboBox();

    protected abstract void updateApplicationUI();

    protected abstract CloudNotifier getNotifier();

    protected abstract class ConnectionTask<T>
    extends CloudConnectionTask<T, SC, DC, SR> {
        public ConnectionTask(String title) {
            super(CloudSupportConfigurableBase.this.myModelProject, title, CloudSupportConfigurableBase.this.getServer());
        }

        public ConnectionTask(Module module, String title) {
            super(module.getProject(), title, CloudSupportConfigurableBase.this.getServer());
        }
    }
}

