/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CloudRuntimeTask<T, DC extends DeploymentConfiguration, SR extends CloudServerRuntimeInstance<DC>> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudRuntimeTask.class.getName()));
    private final Project myProject;
    private final String myTitle;
    private final AtomicReference<Boolean> mySuccess = new AtomicReference();
    private final AtomicReference<String> myErrorMessage = new AtomicReference();

    public CloudRuntimeTask(Project project, String title) {
        this.myProject = project;
        this.myTitle = title;
    }

    public T performSync() {
        return this.perform(true);
    }

    public void performAsync() {
        this.perform(false);
    }

    private T perform(boolean modal) {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Progressive progressive = new Progressive(){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudRuntimeTask$1", "run"));
                }
                indicator.setIndeterminate(true);
                while (!indicator.isCanceled() && !semaphore.waitFor(500L)) {
                }
            }
        };
        boolean cancellable = this.isCancellable(modal);
        Object task = modal ? new Task.Modal(this.myProject, this.myTitle, cancellable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudRuntimeTask$2", "run"));
                }
                progressive.run(indicator);
            }
        } : new Task.Backgroundable(this.myProject, this.myTitle, cancellable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudRuntimeTask$3", "run"));
                }
                progressive.run(indicator);
            }
        };
        this.mySuccess.set(false);
        this.myErrorMessage.set(null);
        AtomicReference result = new AtomicReference();
        this.run(semaphore, result);
        task.queue();
        return (T)result.get();
    }

    protected boolean isCancellable(boolean modal) {
        return modal;
    }

    protected void run(Semaphore semaphore, AtomicReference<T> result) {
        this.run(this.getServerRuntime(), semaphore, result);
    }

    protected void run(SR serverRuntime, Semaphore semaphore, final AtomicReference<T> result) {
        ((CloudServerRuntimeInstance)((Object)serverRuntime)).getTaskExecutor().submit(new Runnable((CloudServerRuntimeInstance)((Object)serverRuntime), semaphore){
            final /* synthetic */ CloudServerRuntimeInstance val$serverRuntime;
            final /* synthetic */ Semaphore val$semaphore;
            {
                this.val$serverRuntime = cloudServerRuntimeInstance;
                this.val$semaphore = semaphore;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    result.set(CloudRuntimeTask.this.run(this.val$serverRuntime));
                    CloudRuntimeTask.this.mySuccess.set(true);
                }
                catch (ServerRuntimeException e) {
                    CloudRuntimeTask.this.runtimeErrorOccurred(e.getMessage());
                }
                finally {
                    this.val$semaphore.up();
                }
            }
        });
    }

    protected void runtimeErrorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudRuntimeTask", "runtimeErrorOccurred"));
        }
        this.myErrorMessage.set(errorMessage);
        LOG.info(errorMessage);
    }

    public void showMessageDialog(JComponent component, String successMessage, String title) {
        if (this.mySuccess.get().booleanValue()) {
            Messages.showInfoMessage((Component)component, (String)successMessage, (String)title);
            return;
        }
        String errorMessage = this.myErrorMessage.get();
        if (errorMessage != null) {
            Messages.showErrorDialog((Component)component, (String)errorMessage, (String)title);
        }
    }

    protected abstract SR getServerRuntime();

    protected abstract T run(SR var1) throws ServerRuntimeException;
}

