/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.remoteServer.agent.util.CloudLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import java.util.HashMap;

public class CloudLoggingHandlerImpl
implements CloudLoggingHandler {
    private final HashMap<String, LogListener> myPipeName2LogListener;
    private final LoggingHandler myMainLoggingHandler;
    private final DeploymentLogManager myLogManager;

    public CloudLoggingHandlerImpl(DeploymentLogManager logManager) {
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        this.myPipeName2LogListener = new HashMap();
        this.myLogManager = logManager;
    }

    public void println(String message) {
        this.myMainLoggingHandler.print(message + "\n");
    }

    public LogListener getOrCreateLogListener(String pipeName) {
        LogListener logListener = this.myPipeName2LogListener.get(pipeName);
        if (logListener == null) {
            final LoggingHandler loggingHandler = this.myLogManager.addAdditionalLog(pipeName);
            logListener = new LogListener(){

                public void lineLogged(String line, String deploymentName, String kind) {
                    loggingHandler.print(line + "\n");
                }
            };
            this.myPipeName2LogListener.put(pipeName, logListener);
        }
        return logListener;
    }
}

