/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.remoteServer.agent.util.CloudApplication;
import com.intellij.remoteServer.agent.util.CloudGitAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudSilentLoggingHandlerImpl;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudDeploymentRuntime
extends DeploymentRuntime {
    private final CloudMultiSourceServerRuntimeInstance myServerRuntime;
    private final DeploymentTask myTask;
    private final CloudGitAgentDeployment myDeployment;
    private final String myApplicationName;
    private final String myPresentableName;
    private final CloudLoggingHandler myLoggingHandler;
    @Nullable
    private final DeploymentLogManager myLogManager;

    public CloudDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        this.myServerRuntime = serverRuntime;
        this.myTask = task;
        this.myLogManager = logManager;
        this.myLoggingHandler = logManager == null ? new CloudSilentLoggingHandlerImpl() : new CloudLoggingHandlerImpl(logManager);
        CloudDeploymentNameConfiguration deploymentConfiguration = (CloudDeploymentNameConfiguration)task.getConfiguration();
        this.myApplicationName = deploymentConfiguration.getDeploymentSourceName(source);
        this.myPresentableName = source.getPresentableName();
        this.myDeployment = serverRuntime.getAgent().createDeployment(this.myApplicationName, this.myLoggingHandler);
    }

    protected CloudMultiSourceServerRuntimeInstance getServerRuntime() {
        return this.myServerRuntime;
    }

    protected DeploymentTask getTask() {
        return this.myTask;
    }

    @Nullable
    protected DeploymentLogManager getLogManager() {
        return this.myLogManager;
    }

    public void deploy(ServerRuntimeInstance.DeploymentOperationCallback callback) {
        try {
            CloudApplication application = this.deploy();
            if (this.myLogManager != null) {
                LoggingHandler loggingHandler = this.myLogManager.getMainLoggingHandler();
                loggingHandler.print("Application is available at ");
                loggingHandler.printHyperlink(application.getWebUrl());
                loggingHandler.print("\n");
            }
            callback.succeeded((DeploymentRuntime)this);
        }
        catch (ServerRuntimeException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    public void undeploy(final @NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudDeploymentRuntime", "undeploy"));
        }
        this.myServerRuntime.getTaskExecutor().submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                try {
                    if (!CloudDeploymentRuntime.this.confirmUndeploy()) {
                        throw new ServerRuntimeException("Undeploy cancelled");
                    }
                    CloudDeploymentRuntime.this.undeploy();
                    callback.succeeded();
                }
                catch (ServerRuntimeException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }
        }, (RemoteOperationCallback)callback);
    }

    public CloudGitAgentDeployment getDeployment() {
        return this.myDeployment;
    }

    public Project getProject() {
        return this.myTask.getProject();
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    public AgentTaskExecutor getAgentTaskExecutor() {
        return this.myServerRuntime.getAgentTaskExecutor();
    }

    public CloudLoggingHandler getLoggingHandler() {
        return this.myLoggingHandler;
    }

    public boolean confirmUndeploy() {
        final Ref confirmed = new Ref((Object)false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                String title = CloudBundle.getText("cloud.undeploy.confirm.title", new Object[0]);
                String password;
                while ((password = Messages.showPasswordDialog((String)CloudBundle.getText("cloud.undeploy.confirm.message", CloudDeploymentRuntime.this.myPresentableName), (String)title)) != null) {
                    if (password.equals(CloudDeploymentRuntime.this.myServerRuntime.getConfiguration().getPassword())) {
                        confirmed.set((Object)true);
                        return;
                    }
                    Messages.showErrorDialog((String)CloudBundle.getText("cloud.undeploy.confirm.password.incorrect", new Object[0]), (String)title);
                }
                return;
            }
        }, ModalityState.defaultModalityState());
        return (Boolean)confirmed.get();
    }

    public abstract CloudApplication deploy() throws ServerRuntimeException;

    public abstract void undeploy() throws ServerRuntimeException;
}

