/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConfigurableBase<SC extends CloudConfigurationBase>
implements UnnamedConfigurable {
    protected final SC myConfiguration;

    public CloudConfigurableBase(SC configuration) {
        this.myConfiguration = configuration;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        return !this.getEmailTextField().getText().equals(((CloudConfigurationBase)((Object)this.myConfiguration)).getEmail()) || !new String(this.getPasswordField().getPassword()).equals(((CloudConfigurationBase)((Object)this.myConfiguration)).getPassword());
    }

    public void apply() throws ConfigurationException {
        String email = this.getEmailTextField().getText();
        if (StringUtil.isEmpty((String)email)) {
            throw new RuntimeConfigurationError("Email required");
        }
        String password = new String(this.getPasswordField().getPassword());
        if (StringUtil.isEmpty((String)password)) {
            throw new RuntimeConfigurationError("Password required");
        }
        ((CloudConfigurationBase)((Object)this.myConfiguration)).setEmail(email);
        ((CloudConfigurationBase)((Object)this.myConfiguration)).setPassword(password);
    }

    public void reset() {
        this.getEmailTextField().setText(((CloudConfigurationBase)((Object)this.myConfiguration)).getEmail());
        this.getPasswordField().setText(((CloudConfigurationBase)((Object)this.myConfiguration)).getPassword());
    }

    public void disposeUIResources() {
    }

    protected abstract JComponent getMainPanel();

    protected abstract JTextField getEmailTextField();

    protected abstract JPasswordField getPasswordField();
}

