/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private final Map<RemoteServer<?>, ServerConnection> myConnections = new HashMap();
    private final ServerConnectionEventDispatcher myEventDispatcher = new ServerConnectionEventDispatcher();

    @NotNull
    public <C extends ServerConfiguration> ServerConnection getOrCreateConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl", "getOrCreateConnection"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ServerConnectionImpl connection = this.myConnections.get(server);
        if (connection == null) {
            ServerTaskExecutorImpl executor = new ServerTaskExecutorImpl();
            connection = new ServerConnectionImpl(server, server.getType().createConnector(server, (ServerTaskExecutor)executor), this);
            this.myConnections.put(server, connection);
            this.myEventDispatcher.fireConnectionCreated(connection);
        }
        ServerConnectionImpl serverConnectionImpl = connection;
        if (serverConnectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl", "getOrCreateConnection"));
        }
        return serverConnectionImpl;
    }

    @Nullable
    public <C extends ServerConfiguration> ServerConnection getConnection(@NotNull RemoteServer<C> server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl", "getConnection"));
        }
        return this.myConnections.get(server);
    }

    public void removeConnection(RemoteServer<?> server) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myConnections.remove(server);
    }

    public ServerConnectionEventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    @NotNull
    public Collection<ServerConnection> getConnections() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<ServerConnection> collection = Collections.unmodifiableCollection(this.myConnections.values());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionManagerImpl", "getConnections"));
        }
        return collection;
    }
}

