/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerConfigurable;
import com.intellij.util.IconUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerListConfigurable
extends MasterDetailsComponent
implements OptionalConfigurable,
SearchableConfigurable {
    private final RemoteServersManager myServersManager;
    @Nullable
    private final ServerType<?> myServerType;
    private RemoteServer<?> myLastSelectedServer;

    public RemoteServerListConfigurable(@NotNull RemoteServersManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "<init>"));
        }
        this(manager, null);
    }

    private RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @Nullable ServerType<?> type) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "<init>"));
        }
        this.myServersManager = manager;
        this.myServerType = type;
        this.initTree();
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "createConfigurable"));
        }
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), type);
    }

    @Nls
    public String getDisplayName() {
        return "Clouds";
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        List<RemoteServer<?>> servers = this.getServers();
        for (RemoteServer<?> server : servers) {
            this.addServerNode(server, false);
        }
        super.reset();
    }

    private List<RemoteServer<?>> getServers() {
        if (this.myServerType == null) {
            return this.myServersManager.getServers();
        }
        return this.myServersManager.getServers(this.myServerType);
    }

    private MasterDetailsComponent.MyNode addServerNode(RemoteServer<?> server, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new RemoteServerConfigurable(server, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        if ("RemoteServers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "getId"));
        }
        return "RemoteServers";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    protected void processRemovedItems() {
        HashSet<Object> servers = new HashSet<Object>();
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            servers.add(configurable.getEditableObject());
        }
        ArrayList toDelete = new ArrayList();
        for (RemoteServer<?> remoteServer : this.getServers()) {
            if (servers.contains(remoteServer)) continue;
            toDelete.add(remoteServer);
        }
        for (RemoteServer remoteServer : toDelete) {
            this.myServersManager.removeServer(remoteServer);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet servers = new HashSet(this.getServers());
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            RemoteServer server = (RemoteServer)configurable.getEditableObject();
            server.setName(configurable.getDisplayName());
            if (servers.contains(server)) continue;
            this.myServersManager.addServer(server);
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myServerType == null) {
            actions.add((AnAction)new AddRemoteServerGroup());
        } else {
            actions.add((AnAction)new AddRemoteServerAction(this.myServerType, IconUtil.getAddIcon()));
        }
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions;
    }

    public boolean needDisplay() {
        return ((ServerType[])ServerType.EP_NAME.getExtensions()).length > 0;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public void disposeUIResources() {
        Object selectedObject = this.getSelectedObject();
        this.myLastSelectedServer = selectedObject instanceof RemoteServer ? (RemoteServer)selectedObject : null;
        super.disposeUIResources();
    }

    @Nullable
    public RemoteServer<?> getLastSelectedServer() {
        return this.myLastSelectedServer;
    }

    private List<NamedConfigurable<RemoteServer<?>>> getConfiguredServers() {
        ArrayList configurables = new ArrayList();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            configurables.add(node.getConfigurable());
        }
        return configurables;
    }

    private class AddRemoteServerAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        private AddRemoteServerAction(ServerType<?> serverType, Icon icon) {
            super(serverType.getPresentableName(), null, icon);
            this.myServerType = serverType;
        }

        public void actionPerformed(AnActionEvent e) {
            String name = UniqueNameGenerator.generateUniqueName((String)this.myServerType.getPresentableName(), (Condition)new Condition<String>(){

                public boolean value(String s) {
                    for (NamedConfigurable configurable : RemoteServerListConfigurable.this.getConfiguredServers()) {
                        if (!configurable.getDisplayName().equals(s)) continue;
                        return false;
                    }
                    return true;
                }
            });
            MasterDetailsComponent.MyNode node = RemoteServerListConfigurable.this.addServerNode(RemoteServerListConfigurable.this.myServersManager.createServer(this.myServerType, name), true);
            RemoteServerListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }

    private class AddRemoteServerGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        private AddRemoteServerGroup() {
            super("Add", "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RemoteServerListConfigurable.this.myTree);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ServerType[] serverTypes = (ServerType[])ServerType.EP_NAME.getExtensions();
            AnAction[] actions = new AnAction[serverTypes.length];
            for (int i = 0; i < serverTypes.length; ++i) {
                actions[i] = new AddRemoteServerAction(serverTypes[i], serverTypes[i].getIcon());
            }
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerGroup", "getChildren"));
            }
            return actions;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            return 0;
        }
    }
}

