/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.Semaphore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerConfigurable
extends NamedConfigurable<RemoteServer<?>> {
    private final UnnamedConfigurable myConfigurable;
    private final RemoteServer<?> myServer;
    private String myServerName;
    private boolean myNew;
    private JPanel myMainPanel;
    private JPanel mySettingsPanel;
    private JButton myTestConnectionButton;

    public <C extends ServerConfiguration> RemoteServerConfigurable(RemoteServer<C> server, Runnable treeUpdater, boolean isNew) {
        super(true, treeUpdater);
        this.myServer = server;
        this.myNew = isNew;
        this.$$$setupUI$$$();
        this.myServerName = this.myServer.getName();
        ServerConfiguration c = server.getConfiguration();
        this.myConfigurable = server.getType().createConfigurable(c);
    }

    public RemoteServer<?> getEditableObject() {
        return this.myServer;
    }

    public String getBannerSlogan() {
        return this.myServer.getName();
    }

    public JComponent createOptionsPanel() {
        this.mySettingsPanel.add("Center", this.myConfigurable.createComponent());
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RemoteServerConfigurable.this.myConfigurable.apply();
                }
                catch (ConfigurationException exc) {
                    Messages.showErrorDialog((Component)RemoteServerConfigurable.this.myMainPanel, (String)("Cannot test connection: " + exc.getMessage()), (String)exc.getTitle());
                    return;
                }
                RemoteServerConfigurable.this.testConnection();
            }
        });
        return this.myMainPanel;
    }

    private void testConnection() {
        final ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServer);
        final AtomicReference<Object> showResultRef = new AtomicReference<Object>(null);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        connection.connect(new Runnable(){

            @Override
            public void run() {
                showResultRef.set(new Runnable(){

                    @Override
                    public void run() {
                        if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                            Messages.showInfoMessage((Component)RemoteServerConfigurable.this.myMainPanel, (String)"Connection successful", (String)"Test Connection");
                        } else if (connection.getStatus() == ConnectionStatus.DISCONNECTED) {
                            Messages.showErrorDialog((Component)RemoteServerConfigurable.this.myMainPanel, (String)("Cannot connect: " + connection.getStatusText()), (String)"Test Connection");
                        }
                    }
                });
                semaphore.up();
            }
        });
        new Task.Modal(null, "Connecting...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/RemoteServerConfigurable$3", "run"));
                }
                indicator.setIndeterminate(true);
                while (!indicator.isCanceled() && !semaphore.waitFor(500L)) {
                }
                Runnable showResult = (Runnable)showResultRef.get();
                if (showResult != null) {
                    ApplicationManager.getApplication().invokeLater(showResult);
                }
            }
        }.queue();
    }

    @Nls
    public String getDisplayName() {
        return this.myServerName;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public void setDisplayName(String name) {
        this.myServerName = name;
    }

    public boolean isModified() {
        return this.myNew || this.myConfigurable.isModified() || !this.myServerName.equals(this.myServer.getName());
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
        this.myNew = false;
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myServer.getType().getIcon();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setText("Test connection");
        jButton.setMnemonic('T');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

