/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class WebDeploymentCredentialsHolder {
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    private String myWebServerConfigId;
    private final RemoteCredentialsHolder myRemoteCredentials;
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
        this.myRemoteCredentials = new RemoteCredentialsHolder();
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name, @NotNull RemoteCredentials remoteCredentials) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        if (remoteCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        this.myRemoteCredentials = new RemoteCredentialsHolder();
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name;
        this.myRemoteCredentials.copyFrom(remoteCredentials);
    }

    @NotNull
    public String getWebServerConfigId() {
        String string = this.myWebServerConfigId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/WebDeploymentCredentialsHolder", "getWebServerConfigId"));
        }
        return string;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigId"));
        }
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigName"));
        }
        this.myWebServerConfigName = name;
    }

    public void load(Element element) {
        this.myRemoteCredentials.load(element);
        this.setWebServerConfigId(element.getAttributeValue(WEB_SERVER_CONFIG_ID));
        this.setWebServerConfigName(StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
    }

    public void save(Element element) {
        element.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        this.myRemoteCredentials.save(element);
    }

    public RemoteCredentials getSshCredentials() {
        return this.myRemoteCredentials;
    }
}

