/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringConflictsUtil {
    private RefactoringConflictsUtil() {
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility) {
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(membersToMove, targetClass, conflicts, newVisibility, (PsiElement)targetClass, null);
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<PsiMember> membersToMove, @Nullable PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility, @NotNull PsiElement context, @Nullable Set<PsiMethod> abstractMethods) {
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/refactoring/util/RefactoringConflictsUtil", "analyzeAccessibilityConflicts"));
        }
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        for (PsiMember member : membersToMove) {
            RefactoringConflictsUtil.checkUsedElements(member, (PsiElement)member, membersToMove, abstractMethods, targetClass, context, conflicts);
            RefactoringConflictsUtil.checkAccessibilityConflicts(member, newVisibility, targetClass, membersToMove, conflicts);
        }
    }

    public static void checkAccessibilityConflicts(@NotNull PsiMember member, @PsiModifier.ModifierConstant @Nullable String newVisibility, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        PsiModifierList modifierListCopy = member.getModifierList();
        if (modifierListCopy != null) {
            modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface()) {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)"public");
            }
        }
        if (newVisibility != null && modifierListCopy != null) {
            try {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
            }
            catch (IncorrectOperationException ignore) {
                // empty catch block
            }
        }
        RefactoringConflictsUtil.checkAccessibilityConflicts(member, modifierListCopy, targetClass, membersToMove, conflicts);
    }

    public static void checkAccessibilityConflicts(@NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
            RefactoringConflictsUtil.checkAccessibilityConflicts(psiReference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    public static void checkAccessibilityConflicts(@NotNull PsiReference reference, @NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibilityConflicts"));
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)member.getProject());
        PsiElement ref = reference.getElement();
        if (!RefactoringHierarchyUtil.willBeInTargetClass(ref, membersToMove, targetClass, false)) {
            if (targetClass != null && !manager.getResolveHelper().isAccessible((PsiMember)targetClass, targetClass.getModifierList(), ref, null, null)) {
                String message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)targetClass), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(ref), true)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflicts.putValue((Object)targetClass, (Object)message);
            } else if (!manager.getResolveHelper().isAccessible(member, modifierListCopy, ref, targetClass, null)) {
                String message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), VisibilityUtil.toPresentableText((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierListCopy)), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(ref), true)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflicts.putValue((Object)member, (Object)message);
            }
        }
    }

    public static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<PsiMember> membersToMove, @Nullable Set<PsiMethod> abstractMethods, @Nullable PsiClass targetClass, @NotNull PsiElement context, MultiMap<PsiElement, String> conflicts) {
        PsiElement refElement;
        PsiReferenceExpression refExpr;
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkUsedElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkUsedElements"));
        }
        HashSet moving = new HashSet(membersToMove);
        if (abstractMethods != null) {
            moving.addAll(abstractMethods);
        }
        if (scope instanceof PsiReferenceExpression) {
            refExpr = (PsiReferenceExpression)scope;
            refElement = refExpr.resolve();
            if (refElement instanceof PsiMember) {
                PsiExpression qualifier = refExpr.getQualifierExpression();
                PsiClass accessClass = (PsiClass)(qualifier != null ? PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement() : null);
                if (!(RefactoringHierarchyUtil.willBeInTargetClass(refElement, (Set<? extends PsiMember>)moving, targetClass, false) || accessClass != null && RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)accessClass, (Set<? extends PsiMember>)moving, targetClass, false))) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, accessClass, member, conflicts);
                }
            }
        } else if (scope instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)scope;
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass != null) {
                if (!RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)anonymousClass, (Set<? extends PsiMember>)moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)anonymousClass, context, (PsiClass)anonymousClass, member, conflicts);
                }
            } else {
                PsiMethod refElement2 = newExpression.resolveConstructor();
                if (refElement2 != null && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement2, (Set<? extends PsiMember>)moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement2, context, null, member, conflicts);
                }
            }
        } else if (scope instanceof PsiJavaCodeReferenceElement && (refElement = (refExpr = (PsiJavaCodeReferenceElement)scope).resolve()) instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass(refElement, (Set<? extends PsiMember>)moving, targetClass, false)) {
            RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, null, member, conflicts);
        }
        for (PsiElement child : scope.getChildren()) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
            RefactoringConflictsUtil.checkUsedElements(member, child, membersToMove, abstractMethods, targetClass, context, conflicts);
        }
    }

    public static void checkAccessibility(PsiMember refMember, @NotNull PsiElement newContext, @Nullable PsiClass accessClass, PsiMember member, MultiMap<PsiElement, String> conflicts) {
        PsiField fieldInSubClass;
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/util/RefactoringConflictsUtil", "checkAccessibility"));
        }
        if (!PsiUtil.isAccessible((PsiMember)refMember, (PsiElement)newContext, (PsiClass)accessClass)) {
            String message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)refMember, true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)refMember), RefactoringUIUtil.getDescription((PsiElement)member, false)});
            message = CommonRefactoringUtil.capitalize((String)message);
            conflicts.putValue((Object)refMember, (Object)message);
        } else if (newContext instanceof PsiClass && refMember instanceof PsiField && refMember.getContainingClass() == member.getContainingClass() && (fieldInSubClass = ((PsiClass)newContext).findFieldByName(refMember.getName(), false)) != null && fieldInSubClass != refMember) {
            conflicts.putValue((Object)refMember, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)fieldInSubClass, true) + " would hide " + RefactoringUIUtil.getDescription((PsiElement)refMember, true) + " which is used by moved " + RefactoringUIUtil.getDescription((PsiElement)member, false))));
        }
    }

    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scopes, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(project, scopes, usages, vFile, conflicts);
    }

    public static void analyzeModuleConflicts(Project project, final Collection<? extends PsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        for (PsiElement psiElement : scopes) {
            if (!(psiElement instanceof PsiPackage)) continue;
            return;
        }
        final Module targetModule = ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        for (PsiElement psiElement : scopes) {
            psiElement.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    super.visitReferenceElement(reference);
                    PsiElement resolved = reference.resolve();
                    if (!(resolved == null || reported.contains((Object)resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || PsiSearchScopeUtil.isInScope((GlobalSearchScope)globalSearchScope, (PsiElement)resolved) || resolved instanceof LightElement)) {
                        String scopeDescription = RefactoringUIUtil.getDescription(ConflictsUtil.getContainer((PsiElement)reference), true);
                        String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription(resolved, true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                        conflicts.putValue((Object)resolved, (Object)CommonRefactoringUtil.capitalize((String)message));
                        reported.add((Object)resolved);
                    }
                }
            });
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block2: for (UsageInfo usage : usages) {
            Module module;
            PsiElement element = usage.getElement();
            if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block2;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            Object container = psiFile instanceof PsiJavaFile ? ConflictsUtil.getContainer(element) : psiFile;
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = usage instanceof MoveRenameUsageInfo ? ((MoveRenameUsageInfo)usage).getReferencedElement() : usage.getElement();
            assert (referencedElement != null) : usage;
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription(referencedElement, true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription(referencedElement, true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)referencedElement, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
    }
}

