/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterTablePanel
extends JPanel {
    private final Project myProject;
    private final VariableData[] myVariableData;
    private final TypeSelector[] myParameterTypeSelectors;
    private final JBTable myTable;
    private final MyTableModel myTableModel;
    private final JComboBox myTypeRendererCombo;

    public VariableData[] getVariableData() {
        return this.myVariableData;
    }

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    protected boolean areTypesDirected() {
        return true;
    }

    public ParameterTablePanel(Project project, VariableData[] variableData, PsiElement ... scopeElements) {
        super(new BorderLayout());
        this.myProject = project;
        this.myVariableData = variableData;
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.setCellSelectionEnabled(true);
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn);
        checkboxColumn.setCellRenderer((TableCellRenderer)((Object)new CheckBoxTableCellRenderer()));
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                VariableData data = ParameterTablePanel.this.getVariableData()[row];
                this.setText(data.name);
                return this;
            }
        });
        this.myParameterTypeSelectors = new TypeSelector[this.getVariableData().length];
        for (int i = 0; i < this.myParameterTypeSelectors.length; ++i) {
            final PsiVariable variable = this.getVariableData()[i].variable;
            PsiExpression[] occurrences = ParameterTablePanel.findVariableOccurrences(scopeElements, variable);
            TypeSelectorManagerImpl manager = new TypeSelectorManagerImpl(this.myProject, this.getVariableData()[i].type, occurrences, this.areTypesDirected()){

                @Override
                protected boolean isUsedAfter() {
                    return ParameterTablePanel.this.isUsedAfter(variable);
                }
            };
            this.myParameterTypeSelectors[i] = manager.getTypeSelector();
            this.getVariableData()[i].type = this.myParameterTypeSelectors[i].getSelectedType();
        }
        this.myTypeRendererCombo = new JComboBox<VariableData>(this.getVariableData());
        this.myTypeRendererCombo.setOpaque(true);
        this.myTypeRendererCombo.setBorder(null);
        this.myTypeRendererCombo.setRenderer(new ListCellRendererWrapper<VariableData>(){

            public void customize(JList list, VariableData value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.type.getPresentableText());
                }
            }
        });
        TableColumn typeColumn = this.myTable.getColumnModel().getColumn(1);
        typeColumn.setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            TypeSelector myCurrentSelector;
            final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();

            @Nullable
            public Object getCellEditorValue() {
                return this.myEditorComponent.getEditorValue();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myEditorComponent.setCell(table, row, column);
                this.myEditorComponent.setOptions((Object[])ParameterTablePanel.this.myParameterTypeSelectors[row].getTypes());
                this.myEditorComponent.setDefaultValue((Object)ParameterTablePanel.this.getVariableData()[row].type);
                this.myEditorComponent.setToString((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return ((PsiType)o).getPresentableText();
                    }
                });
                this.myCurrentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
                return this.myEditorComponent;
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){
            private JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.setText(String.valueOf(value));
                this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                if (isSelected) {
                    this.myLabel.setSelectionIcon();
                } else {
                    this.myLabel.setRegularIcon();
                }
                return this.myLabel;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = ParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (ParameterTablePanel.this.getVariableData()[row].passAsParameter) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ParameterTablePanel.this.getVariableData()[row].passAsParameter = valueToBeSet;
                    }
                    ParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)ParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction().createPanel();
        this.add((Component)listPanel, "Center");
        if (this.getVariableData().length > 1) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    protected boolean isUsedAfter(PsiVariable variable) {
        return false;
    }

    public static PsiExpression[] findVariableOccurrences(PsiElement[] scopeElements, final PsiVariable variable) {
        final ArrayList result = new ArrayList();
        for (PsiElement element : scopeElements) {
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    if (!expression.isQualified() && expression.isReferenceTo((PsiElement)variable)) {
                        result.add(expression);
                    }
                }
            });
        }
        return result.toArray(new PsiExpression[result.size()]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private class CheckBoxTableCellRenderer
    extends BooleanTableCellRenderer {
        private CheckBoxTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setEnabled(ParameterTablePanel.this.isEnabled());
            return rendererComponent;
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_TYPE_COLUMN = 1;
        public static final int PARAMETER_NAME_COLUMN = 2;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return ParameterTablePanel.this.getVariableData().length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].name;
                }
                case 1: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].type.getPresentableText();
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter = (Boolean)aValue;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 2: {
                    VariableData data = ParameterTablePanel.this.getVariableData()[rowIndex];
                    String name = (String)aValue;
                    if (JavaPsiFacade.getInstance((Project)ParameterTablePanel.this.myProject).getNameHelper().isIdentifier(name)) {
                        data.name = name;
                    }
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    VariableData data = ParameterTablePanel.this.getVariableData()[rowIndex];
                    data.type = (PsiType)aValue;
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.isEnabled();
                }
                case 2: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter;
                }
                case 1: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter && !(ParameterTablePanel.this.myParameterTypeSelectors[rowIndex].getComponent() instanceof JLabel);
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public void addRow() {
            throw new IllegalAccessError("Not implemented");
        }

        public void removeRow(int index) {
            throw new IllegalAccessError("Not implemented");
        }

        public void exchangeRows(int row, int targetRow) {
            if (row < 0 || row >= ParameterTablePanel.this.getVariableData().length) {
                return;
            }
            if (targetRow < 0 || targetRow >= ParameterTablePanel.this.getVariableData().length) {
                return;
            }
            VariableData currentItem = ParameterTablePanel.this.getVariableData()[row];
            ParameterTablePanel.this.getVariableData()[row] = ParameterTablePanel.this.getVariableData()[targetRow];
            ParameterTablePanel.this.getVariableData()[targetRow] = currentItem;
            TypeSelector currentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
            ((ParameterTablePanel)ParameterTablePanel.this).myParameterTypeSelectors[row] = ParameterTablePanel.this.myParameterTypeSelectors[targetRow];
            ((ParameterTablePanel)ParameterTablePanel.this).myParameterTypeSelectors[targetRow] = currentSelector;
            ParameterTablePanel.this.myTypeRendererCombo.setModel(new DefaultComboBoxModel<VariableData>(ParameterTablePanel.this.getVariableData()));
            ParameterTablePanel.this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
            ParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
            ParameterTablePanel.this.updateSignature();
        }

        public boolean canExchangeRows(int row, int targetRow) {
            if (row < 0 || row >= ParameterTablePanel.this.getVariableData().length) {
                return false;
            }
            return targetRow >= 0 && targetRow < ParameterTablePanel.this.getVariableData().length;
        }
    }
}

