/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InlineUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.util.InlineUtil");

    private InlineUtil() {
    }

    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) throws IncorrectOperationException {
        PsiManager manager = initializer.getManager();
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)initializer);
        PsiClass refParent = RefactoringChangeUtil.getThisClass((PsiElement)ref);
        boolean insertCastWhenUnchecked = ref.getParent() instanceof PsiForeachStatement;
        PsiType varType = variable.getType();
        initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, varType);
        ChangeContextUtil.encodeContextInfo((PsiElement)initializer, false);
        PsiExpression expr = (PsiExpression)InlineUtil.replaceDiamondWithInferredTypesIfNeeded(initializer, (PsiElement)ref);
        PsiType exprType = expr.getType();
        if (exprType != null && (!varType.equals(exprType) && (varType instanceof PsiPrimitiveType || exprType instanceof PsiPrimitiveType) || !TypeConversionUtil.isAssignable((PsiType)varType, (PsiType)exprType) || insertCastWhenUnchecked && JavaGenericsUtil.isRawToGeneric(varType, exprType))) {
            PsiTypeParameter[] typeParameters;
            JavaResolveResult resolveResult;
            PsiElement resolved;
            boolean matchedTypes = false;
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            if (expr instanceof PsiCallExpression && ((PsiCallExpression)expr).getTypeArguments().length == 0 && (resolved = (resolveResult = ((PsiCallExpression)initializer).resolveMethodGenerics()).getElement()) instanceof PsiMethod && (typeParameters = ((PsiMethod)resolved).getTypeParameters()).length > 0) {
                PsiCallExpression copy = (PsiCallExpression)expr.copy();
                for (PsiTypeParameter typeParameter : typeParameters) {
                    PsiType substituted = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (substituted == null) break;
                    copy.getTypeArgumentList().add((PsiElement)elementFactory.createTypeElement(substituted));
                }
                if (varType.equals(copy.getType())) {
                    PsiReferenceExpression methodExpression;
                    PsiExpression qualifierExpression;
                    ((PsiCallExpression)expr).getTypeArgumentList().replace((PsiElement)copy.getTypeArgumentList());
                    if (expr instanceof PsiMethodCallExpression && (qualifierExpression = (methodExpression = ((PsiMethodCallExpression)expr).getMethodExpression()).getQualifierExpression()) == null) {
                        PsiMethod method = (PsiMethod)resolved;
                        PsiClass containingClass = method.getContainingClass();
                        LOG.assertTrue(containingClass != null);
                        if (method.getModifierList().hasModifierProperty("static")) {
                            methodExpression.setQualifierExpression((PsiExpression)elementFactory.createReferenceExpression(containingClass));
                        } else {
                            methodExpression.setQualifierExpression((PsiExpression)InlineUtil.createThisExpression(manager, thisClass, refParent));
                        }
                    }
                    matchedTypes = true;
                }
            }
            if (!matchedTypes) {
                if (varType instanceof PsiEllipsisType && ((PsiEllipsisType)varType).getComponentType().equals(exprType)) {
                    PsiExpressionList argumentList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiExpressionList.class);
                    LOG.assertTrue(argumentList != null);
                    PsiExpression[] arguments = argumentList.getExpressions();
                    StringBuilder builder = new StringBuilder("new ");
                    builder.append(exprType.getCanonicalText());
                    builder.append("[]{");
                    builder.append(StringUtil.join(Arrays.asList(arguments), (Function)new Function<PsiExpression, String>(){

                        public String fun(PsiExpression expr) {
                            return expr.getText();
                        }
                    }, (String)","));
                    builder.append('}');
                    expr.replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText(builder.toString(), (PsiElement)argumentList));
                } else {
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(t)a", null);
                    PsiTypeElement castTypeElement = cast.getCastType();
                    assert (castTypeElement != null);
                    castTypeElement.replace((PsiElement)variable.getTypeElement());
                    PsiExpression operand = cast.getOperand();
                    assert (operand != null);
                    operand.replace((PsiElement)expr);
                    PsiExpression exprCopy = (PsiExpression)expr.copy();
                    cast = (PsiTypeCastExpression)expr.replace((PsiElement)cast);
                    if (!RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)cast)) {
                        expr = cast;
                    } else {
                        PsiTypeCastExpression toReplace = cast;
                        while (toReplace.getParent() instanceof PsiParenthesizedExpression) {
                            toReplace = toReplace.getParent();
                        }
                        expr = (PsiExpression)toReplace.replace((PsiElement)exprCopy);
                    }
                }
            }
        } else if (exprType instanceof PsiLambdaExpressionType) {
            expr = InlineUtil.surroundWithCast(variable, expr, (PsiExpression)((PsiLambdaExpressionType)exprType).getExpression());
        } else if (exprType instanceof PsiMethodReferenceType) {
            expr = InlineUtil.surroundWithCast(variable, expr, (PsiExpression)((PsiMethodReferenceType)exprType).getExpression());
        }
        ChangeContextUtil.clearContextInfo((PsiElement)initializer);
        PsiThisExpression thisAccessExpr = InlineUtil.createThisExpression(manager, thisClass, refParent);
        return (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)expr, thisClass, (PsiExpression)thisAccessExpr);
    }

    private static PsiExpression surroundWithCast(PsiVariable variable, PsiExpression expr, PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiExpressionList) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)JavaPsiFacade.getElementFactory((Project)expr.getProject()).createExpressionFromText("(t)a", null);
            PsiTypeElement castTypeElement = cast.getCastType();
            assert (castTypeElement != null);
            castTypeElement.replace((PsiElement)variable.getTypeElement());
            PsiExpression operand = cast.getOperand();
            assert (operand != null);
            operand.replace((PsiElement)expr);
            expr = (PsiTypeCastExpression)expr.replace((PsiElement)cast);
            if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)expr))) {
                expr = (PsiExpression)expr.replace((PsiElement)((PsiTypeCastExpression)expr).getOperand());
            }
        }
        return expr;
    }

    private static PsiThisExpression createThisExpression(PsiManager manager, PsiClass thisClass, PsiClass refParent) {
        PsiThisExpression thisAccessExpr = null;
        if (Comparing.equal((Object)thisClass, (Object)refParent)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, null);
        } else if (!(thisClass instanceof PsiAnonymousClass)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, thisClass);
        }
        return thisAccessExpr;
    }

    public static void tryToInlineArrayCreationForVarargs(PsiExpression expr) {
        PsiExpressionList exprList;
        if (expr instanceof PsiNewExpression && ((PsiNewExpression)expr).getArrayInitializer() != null && expr.getParent() instanceof PsiExpressionList && (exprList = (PsiExpressionList)expr.getParent()).getParent() instanceof PsiCall && InlineUtil.isSafeToInlineVarargsArgument((PsiCall)exprList.getParent())) {
            InlineUtil.inlineArrayCreationForVarargs((PsiNewExpression)expr);
        }
    }

    public static void inlineArrayCreationForVarargs(PsiNewExpression arrayCreation) {
        PsiExpressionList argumentList = (PsiExpressionList)arrayCreation.getParent();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] args = argumentList.getExpressions();
        PsiArrayInitializerExpression arrayInitializer = arrayCreation.getArrayInitializer();
        try {
            if (arrayInitializer == null) {
                arrayCreation.delete();
                return;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            if (initializers.length > 0) {
                PsiExpression firstElement;
                PsiElement leadingComment;
                PsiElement nextSibling;
                PsiExpression lastInitializerSibling = initializers[initializers.length - 1];
                while (lastInitializerSibling != null && (nextSibling = lastInitializerSibling.getNextSibling()) != null && nextSibling.getNode().getElementType() != JavaTokenType.RBRACE) {
                    lastInitializerSibling = nextSibling;
                }
                if (lastInitializerSibling instanceof PsiWhiteSpace) {
                    lastInitializerSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)lastInitializerSibling, (Class[])new Class[]{PsiWhiteSpace.class});
                }
                if (lastInitializerSibling.getNode().getElementType() == JavaTokenType.COMMA) {
                    lastInitializerSibling = lastInitializerSibling.getPrevSibling();
                }
                if ((leadingComment = PsiTreeUtil.skipSiblingsBackward((PsiElement)(firstElement = initializers[0]), (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiComment) {
                    firstElement = leadingComment;
                }
                argumentList.addRange((PsiElement)firstElement, (PsiElement)lastInitializerSibling);
            }
            args[args.length - 1].delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean isSafeToInlineVarargsArgument(PsiCall expression) {
        JavaResolveResult resolveResult = expression.resolveMethodGenerics();
        PsiElement element = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (element instanceof PsiMethod && ((PsiMethod)element).isVarArgs()) {
            PsiExpression[] args;
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList != null && parameters.length == (args = argumentList.getExpressions()).length) {
                PsiType lastArgType;
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters[args.length - 1];
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
                if (lastArg instanceof PsiNewExpression && (lastArgType = lastArg.getType()) != null && substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType()).isAssignableFrom(lastArgType)) {
                    PsiExpression[] initializers;
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)lastArg).getArrayInitializer();
                    PsiExpression[] psiExpressionArray = initializers = arrayInitializer != null ? arrayInitializer.getInitializers() : PsiExpression.EMPTY_ARRAY;
                    if (InlineUtil.isSafeToFlatten(expression, method, initializers)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isSafeToFlatten(PsiCall callExpression, PsiMethod oldRefMethod, PsiExpression[] arrayElements) {
        PsiCall copy = (PsiCall)callExpression.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        LOG.assertTrue(copyArgumentList != null);
        PsiExpression[] args = copyArgumentList.getExpressions();
        try {
            args[args.length - 1].delete();
            if (arrayElements.length > 0) {
                copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
            }
            return copy.resolveMethod() == oldRefMethod;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean allUsagesAreTailCalls(final PsiMethod method) {
        final List nonTailCallUsages = Collections.synchronizedList(new ArrayList());
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ReferencesSearch.search((PsiElement)method).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference psiReference) {
                        ProgressManager.checkCanceled();
                        if (InlineUtil.getTailCallType(psiReference) == TailCallType.None) {
                            nonTailCallUsages.add(psiReference);
                            return false;
                        }
                        return true;
                    }
                });
            }
        }, RefactoringBundle.message((String)"inline.method.checking.tail.calls.progress"), true, method.getProject());
        return result && nonTailCallUsages.isEmpty();
    }

    public static TailCallType getTailCallType(@NotNull PsiReference psiReference) {
        PsiStatement callStatement;
        PsiMethod callerMethod;
        if (psiReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/util/InlineUtil", "getTailCallType"));
        }
        PsiElement element = psiReference.getElement();
        PsiExpression methodCall = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCall == null) {
            return TailCallType.None;
        }
        if (methodCall.getParent() instanceof PsiReturnStatement) {
            return TailCallType.Return;
        }
        if (methodCall.getParent() instanceof PsiExpressionStatement && (callerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(callStatement = (PsiStatement)methodCall.getParent()), PsiMethod.class)) != null) {
            PsiStatement[] psiStatements = callerMethod.getBody().getStatements();
            return psiStatements.length > 0 && callStatement == psiStatements[psiStatements.length - 1] ? TailCallType.Simple : TailCallType.None;
        }
        return TailCallType.None;
    }

    public static void substituteTypeParams(PsiElement scope, final PsiSubstitutor substitutor, final PsiElementFactory factory) {
        final HashMap replacement = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiElement resolved;
                super.visitTypeElement(typeElement);
                PsiType type = typeElement.getType();
                if (type instanceof PsiClassType && (resolved = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                    PsiType newType = resolveResult.getSubstitutor().putAll(substitutor).substitute((PsiTypeParameter)resolved);
                    if (newType == null) {
                        newType = PsiType.getJavaLangObject((PsiManager)resolved.getManager(), (GlobalSearchScope)resolved.getResolveScope());
                    }
                    try {
                        replacement.put(typeElement, factory.createTypeElement(newType));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        for (PsiElement element : replacement.keySet()) {
            if (!element.isValid()) continue;
            element.replace((PsiElement)replacement.get(element));
        }
    }

    private static PsiElement replaceDiamondWithInferredTypesIfNeeded(PsiExpression initializer, PsiElement ref) {
        PsiDiamondType.DiamondInferenceResult inferenceResult;
        PsiType type;
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (initializer instanceof PsiNewExpression && (classReference = ((PsiNewExpression)initializer).getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && (type = typeParameterElements[0].getType()) instanceof PsiDiamondType && (inferenceResult = ((PsiDiamondType)type).resolveInferredTypes()).getErrorMessage() == null) {
            PsiElement copy = ref.copy();
            PsiElement parent = ref.replace((PsiElement)initializer);
            PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypes((PsiNewExpression)initializer, parent);
            ref = parent.replace(copy);
            if (!result.equals((Object)inferenceResult)) {
                String inferredTypeText = StringUtil.join((Object[])inferenceResult.getTypes(), (Function)new Function<PsiType, String>(){

                    public String fun(PsiType psiType) {
                        return psiType.getCanonicalText();
                    }
                }, (String)", ");
                PsiExpressionList argumentList = ((PsiNewExpression)initializer).getArgumentList();
                if (argumentList != null) {
                    PsiExpression expression = JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText("new " + classReference.getReferenceName() + "<" + inferredTypeText + ">" + argumentList.getText(), (PsiElement)initializer);
                    return ref.replace((PsiElement)expression);
                }
            }
        }
        return ref.replace((PsiElement)initializer);
    }

    public static enum TailCallType {
        None,
        Simple,
        Return;

    }
}

