/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ComboBoxVisibilityGroup
extends ComboBoxAction {
    private String myValue;
    private final DefaultActionGroup myGroup;
    private final Map<String, String> myMap = new HashMap<String, String>();

    protected ComboBoxVisibilityGroup(String[] options, String[] presentableNames, final Runnable run) {
        AnAction[] myActions = new AnAction[options.length];
        for (int i = 0; i < options.length; ++i) {
            final String value = options[i];
            String name = presentableNames[i];
            this.myMap.put(value, name);
            myActions[i] = new AnAction(name){

                public void actionPerformed(AnActionEvent e) {
                    ComboBoxVisibilityGroup.this.setValue(value);
                    run.run();
                }
            };
        }
        this.myGroup = new DefaultActionGroup(myActions);
    }

    public String getValue() {
        return this.myValue;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup defaultActionGroup = this.myGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ComboBoxVisibilityGroup", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    public void setValue(String value) {
        this.getTemplatePresentation().setText(this.myMap.get(value));
        this.myValue = value;
    }
}

