/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameReferenceEditor
extends ReferenceEditorWithBrowseButton {
    public static final Key<Boolean> CLASS_NAME_REFERENCE_FRAGMENT = Key.create((String)"CLASS_NAME_REFERENCE_FRAGMENT");
    private Project myProject;
    private PsiClass mySelectedClass;
    private String myChooserTitle;

    public ClassNameReferenceEditor(@NotNull Project project, @Nullable PsiClass selectedClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/ui/ClassNameReferenceEditor", "<init>"));
        }
        this(project, selectedClass, null);
    }

    public ClassNameReferenceEditor(final @NotNull Project project, @Nullable PsiClass selectedClass, final @Nullable GlobalSearchScope resolveScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/ui/ClassNameReferenceEditor", "<init>"));
        }
        super(null, project, new Function<String, Document>(){

            public Document fun(String s) {
                PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
                PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createReferenceCodeFragment(s, (PsiElement)defaultPackage, true, true);
                fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
                if (resolveScope != null) {
                    fragment.forceResolveScope(resolveScope);
                }
                fragment.putUserData(CLASS_NAME_REFERENCE_FRAGMENT, (Object)true);
                return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
            }
        }, selectedClass != null ? selectedClass.getQualifiedName() : "");
        this.myProject = project;
        this.myChooserTitle = "Choose Class";
        this.addActionListener(new ChooseClassAction());
    }

    public String getChooserTitle() {
        return this.myChooserTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ClassNameReferenceEditor.this.myProject).createWithInnerClassesScopeChooser(ClassNameReferenceEditor.this.myChooserTitle, GlobalSearchScope.projectScope((Project)ClassNameReferenceEditor.this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getParent() instanceof PsiJavaFile || aClass.hasModifierProperty("static");
                }
            }, null);
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                chooser.selectDirectory(ClassNameReferenceEditor.this.mySelectedClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            ClassNameReferenceEditor.this.mySelectedClass = chooser.getSelected();
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                ClassNameReferenceEditor.this.setText(ClassNameReferenceEditor.this.mySelectedClass.getQualifiedName());
            }
        }
    }
}

