/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeMigration.TypeEvaluator");
    private final HashMap<TypeMigrationUsageInfo, LinkedList<PsiType>> myTypeMap;
    private final TypeMigrationRules myRules;
    private final TypeMigrationLabeler myLabeler;

    public TypeEvaluator(LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> types, TypeMigrationLabeler labeler) {
        this.myLabeler = labeler;
        this.myRules = labeler.getRules();
        this.myTypeMap = new HashMap();
        for (Pair pair : types) {
            LinkedList<Object> e = new LinkedList<Object>();
            e.addFirst(pair.getSecond());
            this.myTypeMap.put(pair.getFirst(), e);
        }
    }

    public boolean setType(TypeMigrationUsageInfo usageInfo, @NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/typeMigration/TypeEvaluator", "setType"));
        }
        LinkedList t = (LinkedList)this.myTypeMap.get((Object)usageInfo);
        PsiElement element = usageInfo.getElement();
        if (!(!(type instanceof PsiEllipsisType) || element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod)) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        if (t != null) {
            if (!((PsiType)t.getFirst()).equals(type)) {
                if (element instanceof PsiVariable || element instanceof PsiMethod) {
                    return false;
                }
                t.addFirst(type);
                return true;
            }
        } else {
            LinkedList<PsiType> e = new LinkedList<PsiType>();
            e.addFirst(type);
            this.myTypeMap.put((Object)usageInfo, e);
            return true;
        }
        return false;
    }

    @Nullable
    public PsiType getType(PsiElement element) {
        for (Map.Entry entry : this.myTypeMap.entrySet()) {
            if (!Comparing.equal((Object)element, (Object)((TypeMigrationUsageInfo)((Object)entry.getKey())).getElement())) continue;
            return (PsiType)((LinkedList)entry.getValue()).getFirst();
        }
        if (element.getTextRange() == null) {
            return null;
        }
        return this.getType(new TypeMigrationUsageInfo(element));
    }

    @Nullable
    public PsiType getType(TypeMigrationUsageInfo usageInfo) {
        LinkedList e = (LinkedList)this.myTypeMap.get((Object)usageInfo);
        if (e != null) {
            return (PsiType)e.getFirst();
        }
        return TypeMigrationLabeler.getElementType(usageInfo.getElement());
    }

    @Nullable
    public PsiType evaluateType(PsiExpression expr) {
        if (expr == null) {
            return null;
        }
        LinkedList e = (LinkedList)this.myTypeMap.get((Object)new TypeMigrationUsageInfo((PsiElement)expr));
        if (e != null) {
            return (PsiType)e.getFirst();
        }
        if (expr instanceof PsiArrayAccessExpression) {
            PsiType at = this.evaluateType(((PsiArrayAccessExpression)expr).getArrayExpression());
            if (at instanceof PsiArrayType) {
                return ((PsiArrayType)at).getComponentType();
            }
        } else {
            if (expr instanceof PsiAssignmentExpression) {
                return this.evaluateType(((PsiAssignmentExpression)expr).getLExpression());
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                JavaResolveResult resolveResult = call.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiExpression[] actualParms = call.getArgumentList().getExpressions();
                    return PsiImplUtil.normalizeWildcardTypeByPosition(this.createMethodSubstitution(parameters, actualParms, method, (PsiExpression)call, resolveResult.getSubstitutor(), false).substitute(this.evaluateType((PsiExpression)call.getMethodExpression())), expr);
                }
            } else {
                PsiClass superClass;
                PsiClass psiClass;
                if (expr instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands = ((PsiPolyadicExpression)expr).getOperands();
                    IElementType sign = ((PsiPolyadicExpression)expr).getOperationTokenType();
                    PsiType lType = operands.length > 0 ? this.evaluateType(operands[0]) : null;
                    for (int i = 1; i < operands.length; ++i) {
                        lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)this.evaluateType(operands[i]), (IElementType)sign, (boolean)true);
                    }
                    return lType;
                }
                if (expr instanceof PsiPostfixExpression) {
                    return this.evaluateType(((PsiPostfixExpression)expr).getOperand());
                }
                if (expr instanceof PsiPrefixExpression) {
                    return this.evaluateType(((PsiPrefixExpression)expr).getOperand());
                }
                if (expr instanceof PsiParenthesizedExpression) {
                    return this.evaluateType(((PsiParenthesizedExpression)expr).getExpression());
                }
                if (expr instanceof PsiConditionalExpression) {
                    PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
                    PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
                    PsiType thenType = this.evaluateType(thenExpression);
                    PsiType elseType = this.evaluateType(elseExpression);
                    switch ((thenType == null ? 0 : 1) + (elseType == null ? 0 : 2)) {
                        case 0: {
                            return expr.getType();
                        }
                        case 1: {
                            return thenType;
                        }
                        case 2: {
                            return elseType;
                        }
                        case 3: {
                            if (TypeConversionUtil.areTypesConvertible((PsiType)thenType, (PsiType)elseType)) {
                                return thenType;
                            }
                            if (TypeConversionUtil.areTypesConvertible((PsiType)elseType, (PsiType)thenType)) {
                                return elseType;
                            }
                            switch ((thenType.equals(thenExpression.getType()) ? 0 : 1) + (elseType.equals(elseExpression.getType()) ? 0 : 2)) {
                                case 0: {
                                    return expr.getType();
                                }
                                case 1: {
                                    return thenType;
                                }
                                case 2: {
                                    return elseType;
                                }
                                case 3: {
                                    return expr.getType();
                                }
                            }
                            LOG.error("Must not happen.");
                            return null;
                        }
                    }
                    LOG.error("Must not happen.");
                } else if (expr instanceof PsiNewExpression) {
                    PsiClassType.ClassResolveResult qualifierResult;
                    PsiExpression qualifier = ((PsiNewExpression)expr).getQualifier();
                    if (qualifier != null && (qualifierResult = TypeEvaluator.resolveType(this.evaluateType(qualifier))).getElement() != null) {
                        PsiSubstitutor qualifierSubs = qualifierResult.getSubstitutor();
                        PsiClassType.ClassResolveResult result = TypeEvaluator.resolveType(expr.getType());
                        if (result.getElement() != null) {
                            PsiClass aClass = result.getElement();
                            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, result.getSubstitutor().putAll(qualifierSubs));
                        }
                    }
                } else if (expr instanceof PsiReferenceExpression) {
                    PsiType type = this.evaluateReferenceExpressionType(expr);
                    if (type != null) {
                        return PsiImplUtil.normalizeWildcardTypeByPosition(type, expr);
                    }
                } else if (expr instanceof PsiSuperExpression && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null && (superClass = psiClass.getSuperClass()) != null) {
                    return this.getType(new TypeMigrationUsageInfo((PsiElement)superClass));
                }
            }
        }
        return this.getType((PsiElement)expr);
    }

    @Nullable
    private PsiType evaluateReferenceExpressionType(PsiExpression expr) {
        PsiReferenceExpression ref = (PsiReferenceExpression)expr;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            PsiElement resolvee = ref.resolve();
            if (resolvee == null) {
                return null;
            }
            return resolvee instanceof PsiClass ? JavaPsiFacade.getElementFactory((Project)resolvee.getProject()).createType((PsiClass)resolvee, PsiSubstitutor.EMPTY) : this.getType(resolvee);
        }
        PsiType qualifierType = this.evaluateType(qualifier);
        if (!(qualifierType instanceof PsiArrayType)) {
            PsiElement element = ref.resolve();
            PsiClassType.ClassResolveResult result = TypeEvaluator.resolveType(qualifierType);
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor aSubst = result.getSubstitutor();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType aType = field.getType();
                    PsiClass superClass = field.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    }
                    return aSubst.substitute(aType);
                }
                if (element instanceof PsiMethod) {
                    PsiMethod[] methods;
                    PsiMethod method = (PsiMethod)element;
                    PsiType aType = method.getReturnType();
                    PsiClass superClass = method.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    } else if (InheritanceUtil.isInheritorOrSelf((PsiClass)superClass, (PsiClass)aClass, (boolean)true) && (methods = method.findSuperMethods(aClass)).length > 0) {
                        aType = methods[0].getReturnType();
                    }
                    return aSubst.substitute(aType);
                }
            }
        }
        return null;
    }

    public static PsiClassType.ClassResolveResult resolveType(PsiType type) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass aClass = resolveResult.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            return TypeEvaluator.resolveType(resolveResult.getSubstitutor().substitute((PsiType)baseClassType));
        }
        return resolveResult;
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters, PsiExpression[] actualParms, PsiMethod method, PsiExpression call) {
        return this.createMethodSubstitution(parameters, actualParms, method, call, PsiSubstitutor.EMPTY, false);
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters, PsiExpression[] actualParms, PsiMethod method, PsiExpression call, PsiSubstitutor subst, boolean preferSubst) {
        SubstitutorBuilder substitutorBuilder = new SubstitutorBuilder(method, call, subst);
        for (int i = 0; i < Math.min(parameters.length, actualParms.length); ++i) {
            substitutorBuilder.bindTypeParameters(this.getType((PsiElement)parameters[i]), this.evaluateType(actualParms[i]));
        }
        return substitutorBuilder.createSubstitutor(preferSubst);
    }

    public String getReport() {
        StringBuffer buffer = new StringBuffer();
        Object[] t = new String[this.myTypeMap.size()];
        int k = 0;
        for (TypeMigrationUsageInfo info : this.myTypeMap.keySet()) {
            LinkedList types = (LinkedList)this.myTypeMap.get((Object)info);
            StringBuffer b = new StringBuffer();
            if (types != null) {
                b.append(info.getElement()).append(" : ");
                b.append(StringUtil.join((Collection)types, (Function)new Function<PsiType, String>(){

                    public String fun(PsiType psiType) {
                        return psiType.getCanonicalText();
                    }
                }, (String)" "));
                b.append("\n");
            }
            t[k++] = b.toString();
        }
        Arrays.sort(t);
        for (Object aT : t) {
            buffer.append((String)aT);
        }
        return buffer.toString();
    }

    public LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> getMigratedDeclarations() {
        LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> list = new LinkedList<Pair<TypeMigrationUsageInfo, PsiType>>();
        for (TypeMigrationUsageInfo usageInfo : this.myTypeMap.keySet()) {
            LinkedList types = (LinkedList)this.myTypeMap.get((Object)usageInfo);
            PsiElement element = usageInfo.getElement();
            if (!(element instanceof PsiVariable) && !(element instanceof PsiMethod)) continue;
            list.addLast((Pair<TypeMigrationUsageInfo, PsiType>)new Pair((Object)usageInfo, types.getFirst()));
        }
        return list;
    }

    @Nullable
    static PsiType substituteType(PsiType migrationType, PsiType originalType, boolean captureWildcard, PsiClass originalClass, PsiType rawTypeToReplace) {
        if (originalClass != null) {
            if (((PsiClassType)originalType).hasParameters() && ((PsiClassType)migrationType).hasParameters()) {
                PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)originalClass.getProject()).getResolveHelper();
                PsiClassType rawOriginalType = JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY);
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter parameter : originalClass.getTypeParameters()) {
                    PsiType type = psiResolveHelper.getSubstitutionForTypeParameter(parameter, (PsiType)rawOriginalType, migrationType, false, PsiUtil.getLanguageLevel((PsiElement)originalClass));
                    if (type == null) {
                        return null;
                    }
                    substitutor = substitutor.put(parameter, captureWildcard && type instanceof PsiWildcardType ? ((PsiWildcardType)type).getExtendsBound() : type);
                }
                return substitutor.substitute(rawTypeToReplace);
            }
            return originalType;
        }
        return null;
    }

    public static PsiType substituteType(PsiType migrationTtype, PsiType originalType, boolean isContraVariantPosition) {
        PsiClass originalClass;
        if (originalType instanceof PsiClassType && migrationTtype instanceof PsiClassType && (originalClass = ((PsiClassType)originalType).resolve()) != null) {
            PsiType psiType;
            if (isContraVariantPosition && TypeConversionUtil.erasure((PsiType)originalType).isAssignableFrom(TypeConversionUtil.erasure((PsiType)migrationTtype))) {
                PsiType psiType2;
                PsiSubstitutor substitutor;
                PsiClass psiClass = ((PsiClassType)migrationTtype).resolve();
                PsiSubstitutor psiSubstitutor = substitutor = psiClass != null ? TypeConversionUtil.getClassSubstitutor((PsiClass)originalClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : null;
                if (substitutor != null && (psiType2 = TypeEvaluator.substituteType(migrationTtype, originalType, false, psiClass, (PsiType)JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(originalClass, substitutor))) != null) {
                    return psiType2;
                }
            } else if (!isContraVariantPosition && TypeConversionUtil.erasure((PsiType)migrationTtype).isAssignableFrom(TypeConversionUtil.erasure((PsiType)originalType)) && (psiType = TypeEvaluator.substituteType(migrationTtype, originalType, false, originalClass, (PsiType)JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY))) != null) {
                return psiType;
            }
        }
        return migrationTtype;
    }

    private class SubstitutorBuilder {
        private final Map<PsiTypeParameter, PsiType> myMapping;
        private final PsiMethod myMethod;
        private final PsiExpression myCall;
        private final PsiSubstitutor mySubst;

        public SubstitutorBuilder(PsiMethod method, PsiExpression call, PsiSubstitutor subst) {
            this.mySubst = subst;
            this.myMapping = new HashMap();
            this.myMethod = method;
            this.myCall = call;
        }

        private void update(PsiTypeParameter p, PsiType t) {
            PsiType binding;
            if (t instanceof PsiPrimitiveType) {
                t = ((PsiPrimitiveType)t).getBoxedType((PsiElement)this.myMethod);
            }
            if ((binding = this.myMapping.get(p)) == null) {
                this.myMapping.put(p, t);
            } else if (t != null) {
                this.myMapping.put(p, PsiIntersectionType.createIntersection((PsiType[])new PsiType[]{binding, t}));
            }
        }

        void bindTypeParameters(PsiType formal, PsiType actual) {
            if (formal instanceof PsiWildcardType) {
                formal = ((PsiWildcardType)formal).getBound();
            }
            if (formal instanceof PsiArrayType && actual instanceof PsiArrayType) {
                this.bindTypeParameters(((PsiArrayType)formal).getComponentType(), ((PsiArrayType)actual).getComponentType());
                return;
            }
            Pair<PsiType, PsiType> typePair = TypeEvaluator.this.myRules.bindTypeParameters(formal, actual, this.myMethod, this.myCall, TypeEvaluator.this.myLabeler);
            if (typePair != null) {
                this.bindTypeParameters((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond());
                return;
            }
            PsiClassType.ClassResolveResult resultF = TypeEvaluator.resolveType(formal);
            PsiClass classF = resultF.getElement();
            if (classF != null) {
                PsiSubstitutor superClassSubstitutor;
                if (classF instanceof PsiTypeParameter) {
                    this.update((PsiTypeParameter)classF, actual);
                    return;
                }
                PsiClassType.ClassResolveResult resultA = TypeEvaluator.resolveType(actual);
                PsiClass classA = resultA.getElement();
                if (classA == null) {
                    return;
                }
                if (!classA.equals(classF) && (superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)classF, (PsiClass)classA, (PsiSubstitutor)resultA.getSubstitutor())) != null) {
                    PsiClassType aligned = JavaPsiFacade.getInstance((Project)classF.getProject()).getElementFactory().createType(classF, superClassSubstitutor);
                    this.bindTypeParameters(formal, (PsiType)aligned);
                }
                PsiTypeParameter[] typeParms = classA.getTypeParameters();
                PsiSubstitutor substA = resultA.getSubstitutor();
                PsiSubstitutor substF = resultF.getSubstitutor();
                for (PsiTypeParameter typeParm : typeParms) {
                    this.bindTypeParameters(substF.substitute(typeParm), substA.substitute(typeParm));
                }
            }
        }

        public PsiSubstitutor createSubstitutor(boolean preferSubst) {
            PsiSubstitutor theSubst = this.mySubst;
            if (preferSubst) {
                this.myMapping.keySet().removeAll(this.mySubst.getSubstitutionMap().keySet());
            }
            for (PsiTypeParameter parm : this.myMapping.keySet()) {
                theSubst = theSubst.put(parm, this.myMapping.get(parm));
            }
            return theSubst;
        }
    }
}

