/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeSignatureHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeTypeSignatureHandler.class.getName()));
    public static final String REFACTORING_NAME = "Type Migration";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtilBase.adjustOffset(file, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement element = file.findElementAt(offset);
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent = typeElement.getParent();
            if (parent instanceof PsiVariable || parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
                ChangeTypeSignatureHandler.invoke(project, parent, null, editor);
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"The caret should be positioned on type of field, variable, method or method parameter to be refactored", (String)REFACTORING_NAME, (String)"refactoring.migrateType");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler", "invoke"));
        }
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project, element);
    }

    public static boolean invokeOnElement(Project project, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile) {
            ChangeTypeSignatureHandler.invoke(project, element, null, null);
            return true;
        }
        if (ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project, element, null, null);
            return true;
        }
        return false;
    }

    protected static boolean isClassArgument(PsiElement element) {
        PsiMember member;
        if (element instanceof PsiReferenceParameterList && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class)) instanceof PsiClass) {
            PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
            PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
            return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static void invoke(Project project, PsiElement root, TypeMigrationRules rules, Editor editor) {
        if (Util.canBeMigrated(root)) {
            TypeMigrationDialog dialog = new TypeMigrationDialog(project, root, rules);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered"), (String)RefactoringBundle.message((String)"unable.to.start.type.migration"), null);
    }
}

