/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.Bottom;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.PsiExtendedTypeVisitor;
import com.intellij.refactoring.typeCook.deductive.builder.Constraint;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.builder.Subtype;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.refactoring.typeCook.deductive.resolver.BindingFactory;
import com.intellij.refactoring.typeCook.deductive.resolver.SolutionHolder;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ResolverTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeCook.deductive.resolver.ResolverTree");
    private ResolverTree[] mySons = new ResolverTree[0];
    private final BindingFactory myBindingFactory;
    private Binding myCurrentBinding;
    private final SolutionHolder mySolutions;
    private final Project myProject;
    private final TObjectIntHashMap<PsiTypeVariable> myBindingDegree;
    private final Settings mySettings;
    private boolean mySolutionFound = false;
    private HashSet<Constraint> myConstraints;

    public ResolverTree(ReductionSystem system) {
        this.myBindingFactory = new BindingFactory(system);
        this.mySolutions = new SolutionHolder();
        this.myCurrentBinding = this.myBindingFactory.create();
        this.myConstraints = system.getConstraints();
        this.myProject = system.getProject();
        this.myBindingDegree = this.calculateDegree();
        this.mySettings = system.getSettings();
        this.reduceCyclicVariables();
    }

    private ResolverTree(ResolverTree parent, HashSet<Constraint> constraints, Binding binding) {
        this.myBindingFactory = parent.myBindingFactory;
        this.myCurrentBinding = binding;
        this.mySolutions = parent.mySolutions;
        this.myConstraints = constraints;
        this.myProject = parent.myProject;
        this.myBindingDegree = this.calculateDegree();
        this.mySettings = parent.mySettings;
    }

    private boolean isBoundElseWhere(PsiTypeVariable var) {
        return this.myBindingDegree.get((Object)var) != 1;
    }

    private boolean canBePruned(Binding b) {
        if (this.mySettings.exhaustive()) {
            return false;
        }
        for (PsiTypeVariable var : b.getBoundVariables()) {
            PsiType type = b.apply(var);
            if (type instanceof PsiTypeVariable || !this.isBoundElseWhere(var)) continue;
            return false;
        }
        return true;
    }

    private TObjectIntHashMap<PsiTypeVariable> calculateDegree() {
        TObjectIntHashMap result = new TObjectIntHashMap();
        for (Constraint constr : this.myConstraints) {
            PsiTypeVarCollector collector = new PsiTypeVarCollector();
            this.setDegree(collector.getSet(constr.getRight()), (TObjectIntHashMap<PsiTypeVariable>)result);
        }
        return result;
    }

    private void setDegree(HashSet<PsiTypeVariable> set, TObjectIntHashMap<PsiTypeVariable> result) {
        for (PsiTypeVariable var : set) {
            result.increment((Object)var);
        }
    }

    private HashSet<Constraint> apply(Binding b) {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Constraint constr : this.myConstraints) {
            result.add(constr.apply(b));
        }
        return result;
    }

    private HashSet<Constraint> apply(Binding b, HashSet<Constraint> additional) {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Constraint constr : this.myConstraints) {
            result.add(constr.apply(b));
        }
        for (Constraint constr : additional) {
            result.add(constr.apply(b));
        }
        return result;
    }

    private ResolverTree applyRule(Binding b) {
        Binding newBinding = b != null ? this.myCurrentBinding.compose(b) : null;
        return newBinding == null ? null : new ResolverTree(this, this.apply(b), newBinding);
    }

    private ResolverTree applyRule(Binding b, HashSet<Constraint> additional) {
        Binding newBinding = b != null ? this.myCurrentBinding.compose(b) : null;
        return newBinding == null ? null : new ResolverTree(this, this.apply(b, additional), newBinding);
    }

    private void reduceCyclicVariables() {
        PsiTypeVariable toVar;
        PsiTypeVariable fromVar;
        final HashSet<PsiTypeVariable> nodes = new HashSet<PsiTypeVariable>();
        HashSet<Constraint> candidates = new HashSet<Constraint>();
        final HashMap ins = new HashMap();
        final HashMap outs = new HashMap();
        for (Constraint constraint : this.myConstraints) {
            PsiType left = constraint.getLeft();
            PsiType right = constraint.getRight();
            if (!(left instanceof PsiTypeVariable) || !(right instanceof PsiTypeVariable)) continue;
            PsiTypeVariable leftVar = (PsiTypeVariable)left;
            PsiTypeVariable rightVar = (PsiTypeVariable)right;
            candidates.add(constraint);
            nodes.add(leftVar);
            nodes.add(rightVar);
            HashSet in = (HashSet)ins.get((Object)leftVar);
            HashSet out = (HashSet)outs.get((Object)rightVar);
            if (in == null) {
                HashSet<PsiTypeVariable> newIn = new HashSet<PsiTypeVariable>();
                newIn.add(rightVar);
                ins.put(leftVar, newIn);
            } else {
                in.add(rightVar);
            }
            if (out == null) {
                HashSet<PsiTypeVariable> newOut = new HashSet<PsiTypeVariable>();
                newOut.add(leftVar);
                outs.put(rightVar, newOut);
                continue;
            }
            out.add(leftVar);
        }
        final DFSTBuilder dfstBuilder = new DFSTBuilder((Graph)new Graph<PsiTypeVariable>(){

            public Collection<PsiTypeVariable> getNodes() {
                return nodes;
            }

            public Iterator<PsiTypeVariable> getIn(PsiTypeVariable n) {
                HashSet in = (HashSet)ins.get((Object)n);
                if (in == null) {
                    return new HashSet().iterator();
                }
                return in.iterator();
            }

            public Iterator<PsiTypeVariable> getOut(PsiTypeVariable n) {
                HashSet out = (HashSet)outs.get((Object)n);
                if (out == null) {
                    return new HashSet().iterator();
                }
                return out.iterator();
            }
        });
        TIntArrayList sccs = dfstBuilder.getSCCs();
        final HashMap index = new HashMap();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                for (int j = 0; j < size; ++j) {
                    index.put(dfstBuilder.getNodeByTNumber(this.myTNumber + j), this.myTNumber);
                }
                this.myTNumber += size;
                return true;
            }
        });
        for (Constraint constraint : candidates) {
            if (!((Integer)index.get(constraint.getLeft())).equals(index.get(constraint.getRight()))) continue;
            this.myConstraints.remove(constraint);
        }
        Binding binding = this.myBindingFactory.create();
        Iterator i$ = index.keySet().iterator();
        while (i$.hasNext() && (((Object)((Object)(fromVar = (PsiTypeVariable)((Object)i$.next())))).equals((Object)(toVar = (PsiTypeVariable)((Object)dfstBuilder.getNodeByNNumber(((Integer)index.get((Object)fromVar)).intValue())))) || (binding = binding.compose(this.myBindingFactory.create(fromVar, toVar))) != null)) {
        }
        if (binding != null && binding.nonEmpty()) {
            this.myCurrentBinding = this.myCurrentBinding.compose(binding);
            this.myConstraints = this.apply(binding);
        }
    }

    private void reduceTypeType(Constraint constr) {
        Binding wcrdBinding;
        Binding sinkBinding;
        PsiType left = constr.getLeft();
        PsiType right = constr.getRight();
        HashSet<Constraint> addendumRise = new HashSet<Constraint>();
        HashSet<Constraint> addendumSink = new HashSet<Constraint>();
        HashSet<Constraint> addendumWcrd = new HashSet<Constraint>();
        int numSons = 0;
        Binding riseBinding = this.myBindingFactory.rise(left, right, addendumRise);
        if (riseBinding != null) {
            ++numSons;
        }
        if ((sinkBinding = this.myBindingFactory.sink(left, right, addendumSink)) != null) {
            ++numSons;
        }
        Binding binding = wcrdBinding = this.mySettings.cookToWildcards() ? this.myBindingFactory.riseWithWildcard(left, right, addendumWcrd) : null;
        if (wcrdBinding != null) {
            ++numSons;
        }
        Binding omitBinding = null;
        if (this.mySettings.exhaustive()) {
            PsiClassType.ClassResolveResult rightResult = Util.resolveType(right);
            PsiClassType.ClassResolveResult leftResult = Util.resolveType(left);
            PsiClass rightClass = rightResult.getElement();
            PsiClass leftClass = leftResult.getElement();
            if (rightClass != null && leftClass != null && rightClass.getManager().areElementsEquivalent((PsiElement)rightClass, (PsiElement)leftClass) && PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)rightClass).hasNext()) {
                omitBinding = this.myBindingFactory.create();
                ++numSons;
                for (PsiType type : rightResult.getSubstitutor().getSubstitutionMap().values()) {
                    if (type instanceof Bottom) continue;
                    --numSons;
                    omitBinding = null;
                    break;
                }
            }
        }
        if (numSons == 0) {
            return;
        }
        if (riseBinding != null && sinkBinding != null && riseBinding.equals(sinkBinding) || this.canBePruned(riseBinding)) {
            --numSons;
            sinkBinding = null;
        }
        if (riseBinding != null && wcrdBinding != null && riseBinding.equals(wcrdBinding)) {
            --numSons;
            wcrdBinding = null;
        }
        this.myConstraints.remove(constr);
        this.mySons = new ResolverTree[numSons];
        int n = 0;
        if (riseBinding != null) {
            this.mySons[n++] = this.applyRule(riseBinding, addendumRise);
        }
        if (wcrdBinding != null) {
            this.mySons[n++] = this.applyRule(wcrdBinding, addendumWcrd);
        }
        if (omitBinding != null) {
            this.mySons[n++] = this.applyRule(omitBinding, addendumWcrd);
        }
        if (sinkBinding != null) {
            this.mySons[n++] = this.applyRule(sinkBinding, addendumSink);
        }
    }

    private void fillTypeRange(PsiType lowerBound, PsiType upperBound, HashSet<PsiType> holder) {
        if (lowerBound instanceof PsiClassType && upperBound instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resultLower = ((PsiClassType)lowerBound).resolveGenerics();
            PsiClassType.ClassResolveResult resultUpper = ((PsiClassType)upperBound).resolveGenerics();
            PsiClass lowerClass = resultLower.getElement();
            PsiClass upperClass = resultUpper.getElement();
            if (lowerClass != null && upperClass != null && !lowerClass.equals(upperClass)) {
                PsiSubstitutor upperSubst = resultUpper.getSubstitutor();
                PsiClass[] parents = upperClass.getSupers();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
                for (PsiClass parent : parents) {
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)parent, (PsiClass)upperClass, (PsiSubstitutor)upperSubst);
                    if (superSubstitutor == null) continue;
                    PsiClassType type = factory.createType(parent, superSubstitutor);
                    holder.add((PsiType)type);
                    this.fillTypeRange(lowerBound, (PsiType)type, holder);
                }
            }
        } else if (lowerBound instanceof PsiArrayType && upperBound instanceof PsiArrayType) {
            this.fillTypeRange(((PsiArrayType)lowerBound).getComponentType(), ((PsiArrayType)upperBound).getComponentType(), holder);
        }
    }

    private PsiType[] getTypeRange(PsiType lowerBound, PsiType upperBound) {
        HashSet<PsiType> range = new HashSet<PsiType>();
        range.add(lowerBound);
        range.add(upperBound);
        this.fillTypeRange(lowerBound, upperBound, range);
        return range.toArray(PsiType.createArray((int)range.size()));
    }

    private void reduceInterval(Constraint left, Constraint right) {
        PsiType type;
        int i;
        Binding sinkBinding;
        PsiType leftType = left.getLeft();
        PsiType rightType = right.getRight();
        PsiTypeVariable var = (PsiTypeVariable)left.getRight();
        if (leftType.equals(rightType)) {
            Binding binding = this.myBindingFactory.create(var, leftType);
            this.myConstraints.remove(left);
            this.myConstraints.remove(right);
            this.mySons = new ResolverTree[]{this.applyRule(binding)};
            return;
        }
        Binding riseBinding = this.myBindingFactory.rise(leftType, rightType, null);
        int indicator = (riseBinding == null ? 0 : 1) + ((sinkBinding = this.myBindingFactory.sink(leftType, rightType, null)) == null ? 0 : 1);
        if (indicator == 0) {
            return;
        }
        if (indicator == 2 && riseBinding.equals(sinkBinding) || this.canBePruned(riseBinding)) {
            indicator = 1;
            sinkBinding = null;
        }
        PsiType[] riseRange = PsiType.EMPTY_ARRAY;
        PsiType[] sinkRange = PsiType.EMPTY_ARRAY;
        if (riseBinding != null) {
            riseRange = this.getTypeRange(riseBinding.apply(rightType), riseBinding.apply(leftType));
        }
        if (sinkBinding != null) {
            sinkRange = this.getTypeRange(sinkBinding.apply(rightType), sinkBinding.apply(leftType));
        }
        if (riseRange.length + sinkRange.length > 0) {
            this.myConstraints.remove(left);
            this.myConstraints.remove(right);
        }
        this.mySons = new ResolverTree[riseRange.length + sinkRange.length];
        for (i = 0; i < riseRange.length; ++i) {
            type = riseRange[i];
            this.mySons[i] = this.applyRule(riseBinding.compose(this.myBindingFactory.create(var, type)));
        }
        for (i = 0; i < sinkRange.length; ++i) {
            type = sinkRange[i];
            this.mySons[i + riseRange.length] = this.applyRule(sinkBinding.compose(this.myBindingFactory.create(var, type)));
        }
    }

    private void reduce() {
        PsiType right;
        PsiType left;
        if (this.myConstraints.isEmpty()) {
            return;
        }
        if (this.myCurrentBinding.isCyclic()) {
            this.reduceCyclicVariables();
        }
        HashMap<PsiTypeVariable, Constraint> myTypeVarConstraints = new HashMap<PsiTypeVariable, Constraint>();
        HashMap<PsiTypeVariable, Constraint> myVarTypeConstraints = new HashMap<PsiTypeVariable, Constraint>();
        for (Constraint constr : this.myConstraints) {
            left = constr.getLeft();
            right = constr.getRight();
            switch ((left instanceof PsiTypeVariable ? 0 : 1) + (right instanceof PsiTypeVariable ? 0 : 2)) {
                case 0: {
                    break;
                }
                case 1: {
                    Constraint d;
                    Constraint c = (Constraint)myTypeVarConstraints.get(right);
                    if (c == null) {
                        d = (Constraint)myVarTypeConstraints.get(right);
                        if (d != null) {
                            this.reduceInterval(constr, d);
                            return;
                        }
                        myTypeVarConstraints.put((PsiTypeVariable)right, constr);
                        break;
                    }
                    this.reduceTypeVar(constr, c);
                    return;
                }
                case 2: {
                    Constraint d;
                    Constraint c = (Constraint)myVarTypeConstraints.get(left);
                    if (c == null) {
                        d = (Constraint)myTypeVarConstraints.get(left);
                        if (d != null) {
                            this.reduceInterval(d, constr);
                            return;
                        }
                        myVarTypeConstraints.put((PsiTypeVariable)left, constr);
                        break;
                    }
                    this.reduceVarType(constr, c);
                    return;
                }
                case 3: {
                    this.reduceTypeType(constr);
                    return;
                }
            }
        }
        for (Constraint constr : this.myConstraints) {
            left = constr.getLeft();
            right = constr.getRight();
            if (left instanceof PsiTypeVariable || !(right instanceof PsiTypeVariable)) continue;
            HashSet<PsiTypeVariable> bound = new PsiTypeVarCollector().getSet(left);
            if (bound.contains(right)) {
                this.myConstraints.remove(constr);
                this.mySons = new ResolverTree[]{this.applyRule(this.myBindingFactory.create((PsiTypeVariable)right, Bottom.BOTTOM))};
                return;
            }
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            PsiType leftType = left instanceof PsiWildcardType ? ((PsiWildcardType)left).getBound() : left;
            PsiType[] types = this.getTypeRange((PsiType)PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)), leftType);
            this.mySons = new ResolverTree[types.length];
            if (types.length > 0) {
                this.myConstraints.remove(constr);
            }
            for (int i = 0; i < types.length; ++i) {
                PsiType type = types[i];
                this.mySons[i] = this.applyRule(this.myBindingFactory.create((PsiTypeVariable)right, type));
            }
            return;
        }
        HashSet<PsiTypeVariable> haveLeftBound = new HashSet<PsiTypeVariable>();
        Constraint target = null;
        HashSet<PsiTypeVariable> boundVariables = new HashSet<PsiTypeVariable>();
        for (Constraint constr : this.myConstraints) {
            PsiType leftType = constr.getLeft();
            PsiType rightType = constr.getRight();
            if (!(leftType instanceof PsiTypeVariable)) continue;
            boundVariables.add((PsiTypeVariable)leftType);
            if (rightType instanceof PsiTypeVariable) {
                boundVariables.add((PsiTypeVariable)rightType);
                haveLeftBound.add((PsiTypeVariable)rightType);
                continue;
            }
            if (Util.bindsTypeVariables(rightType)) continue;
            target = constr;
        }
        if (target == null) {
            if (this.mySettings.exhaustive()) {
                for (Constraint constr : this.myConstraints) {
                    PsiType left2 = constr.getLeft();
                    PsiType right2 = constr.getRight();
                    PsiType[] range = null;
                    PsiTypeVariable var = null;
                    if (left2 instanceof PsiTypeVariable && !(right2 instanceof PsiTypeVariable)) {
                        range = this.getTypeRange((PsiType)PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)this.myProject), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)), right2);
                        var = (PsiTypeVariable)left2;
                    }
                    if (range == null && right2 instanceof PsiTypeVariable && !(left2 instanceof PsiTypeVariable)) {
                        range = new PsiType[]{right2};
                        var = (PsiTypeVariable)right2;
                    }
                    if (range == null) continue;
                    this.mySons = new ResolverTree[range.length];
                    for (int i = 0; i < range.length; ++i) {
                        this.mySons[i] = this.applyRule(this.myBindingFactory.create(var, range[i]));
                    }
                    return;
                }
            }
            Binding binding = this.myBindingFactory.create();
            for (PsiTypeVariable var : this.myBindingFactory.getBoundVariables()) {
                if (this.myCurrentBinding.binds(var) || boundVariables.contains((Object)var)) continue;
                binding = binding.compose(this.myBindingFactory.create(var, Bottom.BOTTOM));
            }
            if (!binding.nonEmpty()) {
                this.myConstraints.clear();
            }
            this.mySons = new ResolverTree[]{this.applyRule(binding)};
        } else {
            PsiType type = target.getRight();
            PsiTypeVariable var = (PsiTypeVariable)target.getLeft();
            Binding binding = haveLeftBound.contains((Object)var) || type instanceof PsiWildcardType || !this.mySettings.cookToWildcards() ? this.myBindingFactory.create(var, type) : this.myBindingFactory.create(var, (PsiType)PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)this.myProject), (PsiType)type));
            this.myConstraints.remove(target);
            this.mySons = new ResolverTree[]{this.applyRule(binding)};
        }
    }

    private void logSolution() {
        LOG.debug("Reduced system:");
        for (Constraint constr : this.myConstraints) {
            LOG.debug(constr.toString());
        }
        LOG.debug("End of Reduced system.");
        LOG.debug("Reduced binding:");
        LOG.debug(this.myCurrentBinding.toString());
        LOG.debug("End of Reduced binding.");
    }

    private void reduceTypeVar(Constraint x, Constraint y) {
        this.reduceSideVar(x, y, new Reducer(){

            @Override
            public LinkedList<Pair<PsiType, Binding>> unify(PsiType x, PsiType y) {
                return ResolverTree.this.myBindingFactory.intersect(x, y);
            }

            @Override
            public Constraint create(PsiTypeVariable var, PsiType type) {
                return new Subtype(type, var);
            }

            @Override
            public PsiType getType(Constraint c) {
                return c.getLeft();
            }

            @Override
            public PsiTypeVariable getVar(Constraint c) {
                return (PsiTypeVariable)c.getRight();
            }
        });
    }

    private void reduceVarType(Constraint x, Constraint y) {
        this.reduceSideVar(x, y, new Reducer(){

            @Override
            public LinkedList<Pair<PsiType, Binding>> unify(PsiType x, PsiType y) {
                return ResolverTree.this.myBindingFactory.union(x, y);
            }

            @Override
            public Constraint create(PsiTypeVariable var, PsiType type) {
                return new Subtype(var, type);
            }

            @Override
            public PsiType getType(Constraint c) {
                return c.getRight();
            }

            @Override
            public PsiTypeVariable getVar(Constraint c) {
                return (PsiTypeVariable)c.getLeft();
            }
        });
    }

    private void reduceSideVar(Constraint x, Constraint y, Reducer reducer) {
        PsiType yType;
        PsiTypeVariable var = reducer.getVar(x);
        PsiType xType = reducer.getType(x);
        LinkedList<Pair<PsiType, Binding>> union = reducer.unify(xType, yType = reducer.getType(y));
        if (union.isEmpty()) {
            return;
        }
        this.myConstraints.remove(x);
        this.myConstraints.remove(y);
        this.mySons = new ResolverTree[union.size()];
        int i = 0;
        Constraint prev = null;
        for (Pair pair : union) {
            if (prev != null) {
                this.myConstraints.remove(prev);
            }
            prev = reducer.create(var, (PsiType)pair.getFirst());
            this.myConstraints.add(prev);
            this.mySons[i++] = this.applyRule((Binding)pair.getSecond());
        }
    }

    public void resolve() {
        this.reduce();
        if (this.mySons.length > 0) {
            for (int i = 0; i < this.mySons.length; ++i) {
                if (this.mySons[i] == null) continue;
                this.mySons[i].resolve();
                if (this.mySettings.exhaustive() || !this.mySettings.cookToWildcards() || !this.mySons[i].mySolutionFound) {
                    this.mySons[i] = null;
                    continue;
                }
                break;
            }
        } else if (this.myConstraints.isEmpty()) {
            this.logSolution();
            this.mySolutions.putSolution(this.myCurrentBinding);
            this.mySolutionFound = true;
        }
    }

    public Binding getBestSolution() {
        return this.mySolutions.getBestSolution();
    }

    private static interface Reducer {
        public LinkedList<Pair<PsiType, Binding>> unify(PsiType var1, PsiType var2);

        public Constraint create(PsiTypeVariable var1, PsiType var2);

        public PsiType getType(Constraint var1);

        public PsiTypeVariable getVar(Constraint var1);
    }

    private static class PsiTypeVarCollector
    extends PsiExtendedTypeVisitor {
        final HashSet<PsiTypeVariable> mySet = new HashSet();

        private PsiTypeVarCollector() {
        }

        @Override
        public Object visitTypeVariable(PsiTypeVariable var) {
            this.mySet.add(var);
            return null;
        }

        public HashSet<PsiTypeVariable> getSet(PsiType type) {
            type.accept((PsiTypeVisitor)this);
            return this.mySet;
        }
    }
}

