/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AutomaticVariableRenamer
extends AutomaticRenamer {
    private final Set<PsiNamedElement> myToUnpluralize = new HashSet();

    public AutomaticVariableRenamer(PsiClass aClass, String newClassName, Collection<UsageInfo> usages) {
        String oldClassName = aClass.getName();
        for (UsageInfo info : usages) {
            PsiElement element = info.getElement();
            if (!(element instanceof PsiJavaCodeReferenceElement)) continue;
            PsiDeclarationStatement statement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
            if (statement != null) {
                for (PsiElement declaredElement : statement.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    this.checkRenameVariable(element, (PsiVariable)declaredElement, oldClassName);
                }
                continue;
            }
            PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class);
            if (variable == null) continue;
            this.checkRenameVariable(element, variable, oldClassName);
            if (!(variable instanceof PsiField)) continue;
            for (PsiField field : AutomaticVariableRenamer.getFieldsInSameDeclaration((PsiField)variable)) {
                this.checkRenameVariable(element, (PsiVariable)field, oldClassName);
            }
        }
        this.suggestAllNames(oldClassName, newClassName);
    }

    private static List<PsiField> getFieldsInSameDeclaration(PsiField variable) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        ASTNode node = variable.getNode();
        if (node != null) {
            ASTNode nextField;
            ASTNode comma;
            while ((comma = TreeUtil.skipElements(node.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = TreeUtil.skipElements(comma.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && nextField.getElementType() == JavaElementType.FIELD) {
                result.add((PsiField)nextField.getPsi());
                node = nextField;
            }
        }
        return result;
    }

    private void checkRenameVariable(PsiElement element, PsiVariable variable, String oldClassName) {
        block6: {
            PsiTypeElement[] typeParameterElements;
            PsiJavaCodeReferenceElement ref;
            block5: {
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement == null) {
                    return;
                }
                ref = typeElement.getInnermostComponentReferenceElement();
                if (ref == null) {
                    return;
                }
                String variableName = variable.getName();
                if (variableName != null && !StringUtil.containsIgnoreCase((String)variableName, (String)oldClassName)) {
                    return;
                }
                if (!ref.equals(element)) break block5;
                this.myElements.add(variable);
                if (!(variable.getType() instanceof PsiArrayType)) break block6;
                this.myToUnpluralize.add((PsiNamedElement)variable);
                break block6;
            }
            PsiClassType collectionType = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory().createTypeByFQClassName("java.util.Collection", variable.getResolveScope());
            if (!collectionType.isAssignableFrom(variable.getType())) {
                return;
            }
            for (PsiTypeElement typeParameterElement : typeParameterElements = ref.getParameterList().getTypeParameterElements()) {
                PsiJavaCodeReferenceElement parameterRef = typeParameterElement.getInnermostComponentReferenceElement();
                if (parameterRef == null || !parameterRef.equals(element)) continue;
                this.myElements.add(variable);
                this.myToUnpluralize.add((PsiNamedElement)variable);
                break;
            }
        }
    }

    @Override
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.variables.title");
    }

    @Override
    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.variables.with.the.following.names.to");
    }

    @Override
    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.variable");
    }

    @Override
    public String nameToCanonicalName(String name, PsiNamedElement psiVariable) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
        String propertyName = codeStyleManager.variableNameToPropertyName(name, codeStyleManager.getVariableKind((PsiVariable)psiVariable));
        if (this.myToUnpluralize.contains(psiVariable)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.myToUnpluralize.remove(psiVariable);
        }
        return propertyName;
    }

    @Override
    public String canonicalNameToName(String canonicalName, PsiNamedElement psiVariable) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
        String variableName = codeStyleManager.propertyNameToVariableName(canonicalName, codeStyleManager.getVariableKind((PsiVariable)psiVariable));
        if (this.myToUnpluralize.contains(psiVariable)) {
            return StringUtil.pluralize((String)variableName);
        }
        return variableName;
    }
}

