/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.RenameChooser;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableInplaceRenamer
extends InplaceRefactoring {
    public static final LanguageExtension<ResolveSnapshotProvider> INSTANCE = new LanguageExtension("com.intellij.rename.inplace.resolveSnapshotProvider");
    private ResolveSnapshotProvider.ResolveSnapshot mySnapshot;
    private TextRange mySelectedRange;
    protected Language myLanguage;

    public VariableInplaceRenamer(@NotNull PsiNamedElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/inplace/VariableInplaceRenamer", "<init>"));
        }
        this(elementToRename, editor, elementToRename.getProject());
    }

    public VariableInplaceRenamer(PsiNamedElement elementToRename, Editor editor, Project project) {
        this(elementToRename, editor, project, elementToRename != null ? elementToRename.getName() : null, elementToRename != null ? elementToRename.getName() : null);
    }

    public VariableInplaceRenamer(PsiNamedElement elementToRename, Editor editor, Project project, String initialName, String oldName) {
        super(editor, elementToRename, project, initialName, oldName);
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return super.startsOnTheSameElement(handler, element) && handler instanceof VariableInplaceRenameHandler;
    }

    public boolean performInplaceRename() {
        return this.performInplaceRefactoring(null);
    }

    @Override
    protected void collectAdditionalElementsToRename(final List<Pair<PsiElement, TextRange>> stringUsages) {
        String stringToSearch = this.myElementToRename.getName();
        final PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (stringToSearch != null) {
            TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myElementToRename, stringToSearch, true, new PairProcessor<PsiElement, TextRange>(){

                public boolean process(PsiElement psiElement, TextRange textRange) {
                    if (psiElement.getContainingFile() == currentFile) {
                        stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
                    }
                    return true;
                }
            });
        }
    }

    @Override
    protected boolean buildTemplateAndStart(final Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, final PsiElement scope, final PsiFile containingFile) {
        if (this.appendAdditionalElement(refs, stringUsages)) {
            return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
        }
        RenameChooser renameChooser = new RenameChooser(this.myEditor){

            @Override
            protected void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> stringUsages) {
                VariableInplaceRenamer.super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
            }
        };
        renameChooser.showChooser(refs, stringUsages);
        return true;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        return stringUsages.isEmpty() || StartMarkAction.canStart(this.myProject) != null;
    }

    protected boolean shouldCreateSnapshot() {
        return true;
    }

    @Override
    protected void beforeTemplateStart() {
        SelectionModel selectionModel;
        super.beforeTemplateStart();
        this.myLanguage = this.myScope.getLanguage();
        if (this.shouldCreateSnapshot()) {
            ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)INSTANCE.forLanguage(this.myLanguage);
            this.mySnapshot = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
        }
        this.mySelectedRange = (selectionModel = this.myEditor.getSelectionModel()).hasSelection() ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : null;
    }

    @Override
    protected void restoreSelection() {
        if (this.mySelectedRange != null) {
            this.myEditor.getSelectionModel().setSelection(this.mySelectedRange.getStartOffset(), this.mySelectedRange.getEndOffset());
        } else if (!this.shouldSelectAll()) {
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    @Override
    protected int restoreCaretOffset(int offset) {
        if (this.myCaretRangeMarker.isValid()) {
            if (this.myCaretRangeMarker.getStartOffset() <= offset && this.myCaretRangeMarker.getEndOffset() >= offset) {
                return offset;
            }
            return this.myCaretRangeMarker.getEndOffset();
        }
        return offset;
    }

    @Override
    protected boolean shouldSelectAll() {
        if (this.myEditor.getSettings().isPreselectRename()) {
            return true;
        }
        Boolean selectAll = (Boolean)this.myEditor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        return selectAll != null && selectAll != false;
    }

    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new VariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
    }

    protected void performOnInvalidIdentifier(final String newName, final LinkedHashSet<String> nameSuggestions) {
        final PsiNamedElement variable = this.getVariable();
        if (variable != null) {
            int offset = variable.getTextOffset();
            this.restoreCaretOffset(offset);
            JBPopupFactory.getInstance().createConfirmation("Inserted identifier is not valid", "Continue editing", "Cancel", new Runnable(){

                @Override
                public void run() {
                    VariableInplaceRenamer.this.createInplaceRenamerToRestart(variable, VariableInplaceRenamer.this.myEditor, newName).performInplaceRefactoring(nameSuggestions);
                }
            }, 0).showInBestPositionFor(this.myEditor);
        }
    }

    protected void renameSynthetic(String newName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoringRename(final String newName, StartMarkAction markAction) {
        try {
            if (!this.isIdentifier(newName, this.myLanguage)) {
                return;
            }
            PsiNamedElement elementToRename = this.getVariable();
            if (elementToRename != null) {
                new WriteCommandAction(this.myProject, this.getCommandName(), new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        VariableInplaceRenamer.this.renameSynthetic(newName);
                    }
                }.execute();
            }
            for (AutomaticRenamerFactory renamerFactory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
                if (!renamerFactory.isApplicable((PsiElement)elementToRename)) continue;
                final ArrayList usages = new ArrayList();
                final AutomaticRenamer renamer = renamerFactory.createRenamer((PsiElement)elementToRename, newName, new ArrayList<UsageInfo>());
                if (!renamer.hasAnythingToRename()) continue;
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    AutomaticRenamingDialog renamingDialog = new AutomaticRenamingDialog(this.myProject, renamer);
                    renamingDialog.show();
                    if (!renamingDialog.isOK()) {
                        return;
                    }
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        renamer.findUsages(usages, false, false);
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                    return;
                }
                if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement[])PsiUtilCore.toPsiElementArray(renamer.getElements()))) {
                    return;
                }
                final Runnable performAutomaticRename = new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(VariableInplaceRenamer.this.myProject);
                        UsageInfo[] usageInfos = usages.toArray(new UsageInfo[usages.size()]);
                        MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(renamer.getElements(), usageInfos);
                        for (PsiNamedElement element : renamer.getElements()) {
                            String newElementName = renamer.getNewName(element);
                            if (newElementName == null) continue;
                            Collection infos = classified.get((Object)element);
                            RenameUtil.doRename((PsiElement)element, newElementName, infos.toArray(new UsageInfo[infos.size()]), VariableInplaceRenamer.this.myProject, RefactoringElementListener.DEAF);
                        }
                    }
                };
                final WriteCommandAction writeCommandAction = new WriteCommandAction(this.myProject, this.getCommandName(), new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        performAutomaticRename.run();
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    writeCommandAction.execute();
                    continue;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        writeCommandAction.execute();
                    }
                });
            }
        }
        finally {
            try {
                ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"renaming.command.name", (Object[])new Object[]{this.myInitialName});
    }

    @Override
    protected boolean performRefactoring() {
        boolean bind = false;
        if (this.myInsertedName != null) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (commandProcessor.getCurrentCommand() != null && this.getVariable() != null) {
                commandProcessor.setCurrentCommandName(this.getCommandName());
            }
            bind = true;
            if (!this.isIdentifier(this.myInsertedName, this.myLanguage)) {
                this.performOnInvalidIdentifier(this.myInsertedName, this.myNameSuggestions);
            } else if (this.mySnapshot != null && this.isIdentifier(this.myInsertedName, this.myLanguage)) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        VariableInplaceRenamer.this.mySnapshot.apply(VariableInplaceRenamer.this.myInsertedName);
                    }
                });
            }
            this.performRefactoringRename(this.myInsertedName, this.myMarkAction);
        }
        return bind;
    }

    @Override
    public void finish(boolean success) {
        super.finish(success);
        if (success) {
            this.revertStateOnFinish();
        } else {
            ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
        }
    }

    protected void revertStateOnFinish() {
        if (this.myInsertedName == null || !this.isIdentifier(this.myInsertedName, this.myLanguage)) {
            this.revertState();
        }
    }
}

