/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import org.jetbrains.annotations.NotNull;

public class MemberInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @Override
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        PsiElement nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset());
        if (nameSuggestionContext == null && editor.getCaretModel().getOffset() > 0) {
            nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        if (element == null && LookupManager.getActiveLookup(editor) != null) {
            element = PsiTreeUtil.getParentOfType((PsiElement)nameSuggestionContext, PsiNamedElement.class);
        }
        RefactoringSupportProvider supportProvider = element == null ? null : (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage());
        return editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider != null && supportProvider.isMemberInplaceRenameAvailable(element, nameSuggestionContext);
    }

    @Override
    public InplaceRefactoring doRename(final @NotNull PsiElement elementToRename, final Editor editor, final DataContext dataContext) {
        RenamePsiElementProcessor processor;
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler", "doRename"));
        }
        if (elementToRename instanceof PsiNameIdentifierOwner && (processor = RenamePsiElementProcessor.forElement(elementToRename)).isInplaceRenameSupported()) {
            TemplateState templateState;
            StartMarkAction startMarkAction = StartMarkAction.canStart(elementToRename.getProject());
            if (startMarkAction == null || processor.substituteElementToRename(elementToRename, editor) == elementToRename) {
                processor.substituteElementToRename(elementToRename, editor, new Pass<PsiElement>(){

                    public void pass(PsiElement element) {
                        MemberInplaceRenamer renamer = MemberInplaceRenameHandler.this.createMemberRenamer(element, (PsiNameIdentifierOwner)elementToRename, editor);
                        boolean startedRename = renamer.performInplaceRename();
                        if (!startedRename) {
                            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext);
                        }
                    }
                });
                return null;
            }
            InplaceRefactoring inplaceRefactoring = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
            if (inplaceRefactoring != null && inplaceRefactoring.getClass() == MemberInplaceRenamer.class && (templateState = TemplateManagerImpl.getTemplateState(InjectedLanguageUtil.getTopLevelEditor(editor))) != null) {
                templateState.gotoEnd(true);
            }
        }
        MemberInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext);
        return null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler", "createMemberRenamer"));
        }
        MemberInplaceRenamer memberInplaceRenamer = new MemberInplaceRenamer((PsiNamedElement)elementToRename, element, editor);
        if (memberInplaceRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler", "createMemberRenamer"));
        }
        return memberInplaceRenamer;
    }
}

