/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiPackageProcessor
extends RenamePsiElementProcessor {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenamePsiPackageProcessor");

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/RenamePsiPackageProcessor", "canProcessElement"));
        }
        return element instanceof PsiPackage;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiPackage psiPackage = (PsiPackage)element;
        psiPackage.handleQualifiedNameChange(PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)newName));
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener);
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename((PsiPackage)element, newName, nonJava);
    }

    public static String getPackageQualifiedNameAfterRename(PsiPackage element, String newName, boolean nonJava) {
        if (nonJava) {
            String qName = element.getQualifiedName();
            int index = qName.lastIndexOf(46);
            return index < 0 ? newName : qName.substring(0, index + 1) + newName;
        }
        return newName;
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        PsiPackage aPackage = (PsiPackage)element;
        Project project = element.getProject();
        String qualifiedNameAfterRename = RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(aPackage, newName, true);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            conflicts.putValue((Object)psiClass, (Object)("Class with qualified name '" + qualifiedNameAfterRename + "'  already exist"));
        }
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RenamePsiPackageProcessor.preparePackageRenaming((PsiPackage)element, newName, allRenames);
    }

    public static void preparePackageRenaming(PsiPackage psiPackage, String newName, Map<PsiElement, String> allRenames) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = psiPackage.getDirectories()) {
            if (JavaDirectoryService.getInstance().isSourceRoot(directory)) continue;
            allRenames.put((PsiElement)directory, newName);
        }
    }

    @Override
    @Nullable
    public Runnable getPostRenameCallback(PsiElement element, String newName, final RefactoringElementListener listener) {
        final Project project = element.getProject();
        PsiPackage psiPackage = (PsiPackage)element;
        final String newQualifiedName = PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)newName);
        return new Runnable(){

            @Override
            public void run() {
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(newQualifiedName);
                if (aPackage == null) {
                    return;
                }
                listener.elementRenamed((PsiElement)aPackage);
            }
        };
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renamePackage";
    }

    @Override
    public boolean isToSearchInComments(PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
    }
}

