/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeMethodOrClassStaticProcessor;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;

public class MakeMethodStaticProcessor
extends MakeMethodOrClassStaticProcessor<PsiMethod> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.makeMethodStatic.MakeMethodStaticProcessor");

    public MakeMethodStaticProcessor(Project project, PsiMethod method, Settings settings) {
        super(project, method, settings);
    }

    @Override
    protected void changeSelfUsage(SelfUsageInfo usageInfo) throws IncorrectOperationException {
        PsiElement parent = usageInfo.getElement().getParent();
        LOG.assertTrue(parent instanceof PsiMethodCallExpression);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            qualifier.delete();
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)methodCall.getProject()).getElementFactory();
        PsiExpressionList args = methodCall.getArgumentList();
        PsiElement addParameterAfter = null;
        if (this.mySettings.isMakeClassParameter()) {
            PsiExpression arg = factory.createExpressionFromText(this.mySettings.getClassParameterName(), null);
            addParameterAfter = args.addAfter((PsiElement)arg, null);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiExpression arg = factory.createExpressionFromText(fieldParameter.name, null);
                if (addParameterAfter == null) {
                    addParameterAfter = args.addAfter((PsiElement)arg, null);
                    continue;
                }
                addParameterAfter = args.addAfter((PsiElement)arg, addParameterAfter);
            }
        }
    }

    @Override
    protected void changeSelf(PsiElementFactory factory, UsageInfo[] usages) throws IncorrectOperationException {
        MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper((PsiMethod)this.myMember);
        PsiParameterList paramList = ((PsiMethod)this.myMember).getParameterList();
        PsiElement addParameterAfter = null;
        PsiDocTag anchor = null;
        ArrayList<Object> addedTypes = new ArrayList<Object>();
        if (this.mySettings.isMakeClassParameter()) {
            PsiClassType parameterType = factory.createType(((PsiMethod)this.myMember).getContainingClass(), PsiSubstitutor.EMPTY);
            addedTypes.add(parameterType);
            String classParameterName = this.mySettings.getClassParameterName();
            PsiParameter parameter = factory.createParameter(classParameterName, (PsiType)parameterType);
            if (this.makeClassParameterFinal(usages)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)true);
            }
            addParameterAfter = paramList.addAfter((PsiElement)parameter, null);
            anchor = javaDocHelper.addParameterAfter(classParameterName, anchor);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiType fieldParameterType = fieldParameter.field.getType();
                PsiParameter parameter = factory.createParameter(fieldParameter.name, fieldParameterType);
                addedTypes.add(fieldParameterType);
                if (MakeMethodStaticProcessor.makeFieldParameterFinal(fieldParameter.field, usages)) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)true);
                }
                addParameterAfter = paramList.addAfter((PsiElement)parameter, addParameterAfter);
                anchor = javaDocHelper.addParameterAfter(fieldParameter.name, anchor);
            }
        }
        this.setupTypeParameterList();
        PsiModifierList modifierList = ((PsiMethod)this.myMember).getModifierList();
        modifierList.setModifierProperty("static", true);
        modifierList.setModifierProperty("final", false);
    }

    @Override
    protected void changeInternalUsage(InternalUsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        if (!this.mySettings.isChangeSignature()) {
            return;
        }
        PsiElement element = usage.getElement();
        if (element instanceof PsiReferenceExpression) {
            String name;
            PsiElement resolved;
            PsiReferenceExpression newRef = null;
            if (this.mySettings.isMakeFieldParameters() && (resolved = ((PsiReferenceExpression)element).resolve()) instanceof PsiField && (name = this.mySettings.getNameForField((PsiField)resolved)) != null) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(name, null);
            }
            if (newRef == null && this.mySettings.isMakeClassParameter()) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(this.mySettings.getClassParameterName() + "." + element.getText(), null);
            }
            if (newRef != null) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
                newRef = (PsiReferenceExpression)codeStyleManager.reformat(newRef);
                element.replace((PsiElement)newRef);
            }
        } else if (element instanceof PsiThisExpression && this.mySettings.isMakeClassParameter()) {
            element.replace((PsiElement)factory.createExpressionFromText(this.mySettings.getClassParameterName(), null));
        } else if (element instanceof PsiSuperExpression && this.mySettings.isMakeClassParameter()) {
            element.replace((PsiElement)factory.createExpressionFromText(this.mySettings.getClassParameterName(), null));
        } else if (element instanceof PsiNewExpression && this.mySettings.isMakeClassParameter()) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            LOG.assertTrue(newExpression.getQualifier() == null);
            String newText = this.mySettings.getClassParameterName() + "." + newExpression.getText();
            PsiExpression expr = factory.createExpressionFromText(newText, null);
            element.replace((PsiElement)expr);
        }
    }

    @Override
    protected void changeExternalUsage(UsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel;
        PsiReferenceExpression newQualifier;
        PsiElement element = usage.getElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression methodRef = (PsiReferenceExpression)element;
        PsiElement parent = methodRef.getParent();
        PsiExpression instanceRef = methodRef.getQualifierExpression();
        PsiClass memberClass = ((PsiMethod)this.myMember).getContainingClass();
        if (instanceRef == null || instanceRef instanceof PsiSuperExpression) {
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            instanceRef = !InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)memberClass, (boolean)true) ? factory.createExpressionFromText(memberClass.getQualifiedName() + ".this", null) : factory.createExpressionFromText("this", null);
            newQualifier = null;
        } else {
            newQualifier = factory.createReferenceExpression(memberClass);
        }
        if (this.mySettings.getNewParametersNumber() > 1 && (copyingSafetyLevel = RefactoringUtil.verifySafeCopyExpression((PsiElement)instanceRef)) == 2) {
            String tempVar = RefactoringUtil.createTempVar(instanceRef, parent, true);
            instanceRef = factory.createExpressionFromText(tempVar, null);
        }
        PsiElement anchor = null;
        PsiExpressionList argList = null;
        PsiExpression[] exprs = new PsiExpression[]{};
        if (parent instanceof PsiMethodCallExpression) {
            argList = ((PsiMethodCallExpression)parent).getArgumentList();
            exprs = argList.getExpressions();
            if (this.mySettings.isMakeClassParameter()) {
                anchor = exprs.length > 0 ? argList.addBefore((PsiElement)instanceRef, (PsiElement)exprs[0]) : argList.add((PsiElement)instanceRef);
            }
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiReferenceExpression fieldRef;
                if (newQualifier != null) {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + fieldParameter.field.getName(), null);
                    fieldRef.getQualifierExpression().replace((PsiElement)instanceRef);
                } else {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText(fieldParameter.field.getName(), null);
                }
                if (anchor != null) {
                    anchor = argList.addAfter((PsiElement)fieldRef, anchor);
                    continue;
                }
                if (exprs.length > 0) {
                    anchor = argList.addBefore((PsiElement)fieldRef, (PsiElement)exprs[0]);
                    continue;
                }
                anchor = argList.add((PsiElement)fieldRef);
            }
        }
        if (newQualifier != null) {
            methodRef.getQualifierExpression().replace((PsiElement)newQualifier);
        }
    }

    @Override
    protected void findExternalUsages(ArrayList<UsageInfo> result) {
        this.findExternalReferences((PsiMethod)this.myMember, result);
    }
}

