/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeMethodOrClassStaticViewDescriptor;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.refactoring.makeStatic.OverridingMethodUsageInfo;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MakeMethodOrClassStaticProcessor<T extends PsiTypeParameterListOwner>
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.makeMethodStatic.MakeMethodStaticProcessor");
    protected T myMember;
    protected Settings mySettings;

    public MakeMethodOrClassStaticProcessor(Project project, T member, Settings settings) {
        super(project);
        this.myMember = member;
        this.mySettings = settings;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        MakeMethodOrClassStaticViewDescriptor makeMethodOrClassStaticViewDescriptor = new MakeMethodOrClassStaticViewDescriptor((PsiMember)this.myMember);
        if (makeMethodOrClassStaticViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/makeStatic/MakeMethodOrClassStaticProcessor", "createUsageViewDescriptor"));
        }
        return makeMethodOrClassStaticViewDescriptor;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.makeStatic";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myMember);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myMember);
        return data;
    }

    @Override
    protected final boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            MultiMap<PsiElement, String> conflicts = this.getConflictDescriptions(usagesIn);
            if (conflicts.size() > 0) {
                ConflictsDialog conflictsDialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])refUsages.get());
                conflictsDialog.show();
                if (!conflictsDialog.isOK()) {
                    if (conflictsDialog.isShowConflicts()) {
                        this.prepareSuccessful();
                    }
                    return false;
                }
            }
            if (!this.mySettings.isChangeSignature()) {
                refUsages.set((Object)MakeMethodOrClassStaticProcessor.filterInternalUsages(usagesIn));
            }
        }
        refUsages.set((Object)MakeMethodOrClassStaticProcessor.filterOverriding(usagesIn));
        this.prepareSuccessful();
        return true;
    }

    private static UsageInfo[] filterOverriding(UsageInfo[] usages) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof OverridingMethodUsageInfo) continue;
            result.add(usage);
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    private static UsageInfo[] filterInternalUsages(UsageInfo[] usages) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof InternalUsageInfo) continue;
            result.add(usage);
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    protected MultiMap<PsiElement, String> getConflictDescriptions(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        HashSet<PsiElement> processed = new HashSet<PsiElement>();
        String typeString = StringUtil.capitalize((String)UsageViewUtil.getType(this.myMember));
        for (UsageInfo usageInfo : usages) {
            String message;
            if (usageInfo instanceof InternalUsageInfo && !(usageInfo instanceof SelfUsageInfo)) {
                PsiElement referencedElement = ((InternalUsageInfo)usageInfo).getReferencedElement();
                if (!this.mySettings.isMakeClassParameter()) {
                    if (referencedElement instanceof PsiModifierListOwner && ((PsiModifierListOwner)referencedElement).hasModifierProperty("static") || processed.contains(referencedElement)) continue;
                    processed.add(referencedElement);
                    if (referencedElement instanceof PsiField) {
                        PsiField field = (PsiField)referencedElement;
                        if (this.mySettings.getNameForField(field) == null) {
                            String message2 = RefactoringBundle.message((String)"0.uses.non.static.1.which.is.not.passed.as.a.parameter", (Object[])new Object[]{typeString, RefactoringUIUtil.getDescription((PsiElement)field, true)});
                            conflicts.putValue((Object)field, (Object)message2);
                        }
                    } else {
                        message = RefactoringBundle.message((String)"0.uses.1.which.needs.class.instance", (Object[])new Object[]{typeString, RefactoringUIUtil.getDescription(referencedElement, true)});
                        conflicts.putValue((Object)referencedElement, (Object)message);
                    }
                }
            }
            if (usageInfo instanceof OverridingMethodUsageInfo) {
                LOG.assertTrue(this.myMember instanceof PsiMethod);
                PsiMethod overridingMethod = (PsiMethod)usageInfo.getElement();
                message = RefactoringBundle.message((String)"method.0.is.overridden.by.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.myMember, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)});
                conflicts.putValue((Object)overridingMethod, (Object)message);
                continue;
            }
            PsiElement element = usageInfo.getElement();
            PsiElement container = ConflictsUtil.getContainer(element);
            if (processed.contains(container)) continue;
            processed.add(container);
            List<Settings.FieldParameter> fieldParameters = this.mySettings.getParameterOrderList();
            ArrayList<PsiField> inaccessible = new ArrayList<PsiField>();
            for (Settings.FieldParameter fieldParameter : fieldParameters) {
                if (PsiUtil.isAccessible((PsiMember)fieldParameter.field, (PsiElement)element, null)) continue;
                inaccessible.add(fieldParameter.field);
            }
            if (inaccessible.isEmpty()) continue;
            MakeMethodOrClassStaticProcessor.createInaccessibleFieldsConflictDescription(inaccessible, container, (MultiMap<PsiElement, String>)conflicts);
        }
        return conflicts;
    }

    private static void createInaccessibleFieldsConflictDescription(ArrayList<PsiField> inaccessible, PsiElement container, MultiMap<PsiElement, String> conflicts) {
        if (inaccessible.size() == 1) {
            PsiField field = inaccessible.get(0);
            conflicts.putValue((Object)field, (Object)RefactoringBundle.message((String)"field.0.is.not.accessible", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)field.getName()), RefactoringUIUtil.getDescription(container, true)}));
        } else {
            for (int j = 0; j < inaccessible.size(); ++j) {
                PsiField field = inaccessible.get(j);
                conflicts.putValue((Object)field, (Object)RefactoringBundle.message((String)"field.0.is.not.accessible", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)field.getName()), RefactoringUIUtil.getDescription(container, true)}));
            }
        }
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ContainerUtil.addAll(result, (Object[])MakeStaticUtil.findClassRefsInMember(this.myMember, true));
        if (this.mySettings.isReplaceUsages()) {
            this.findExternalUsages(result);
        }
        if (this.myMember instanceof PsiMethod) {
            PsiMethod[] overridingMethods;
            for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)((PsiMethod)this.myMember), (SearchScope)this.myMember.getUseScope(), (boolean)false).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                if (overridingMethod == this.myMember) continue;
                result.add(new OverridingMethodUsageInfo(overridingMethod));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/makeStatic/MakeMethodOrClassStaticProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected abstract void findExternalUsages(ArrayList<UsageInfo> var1);

    protected void findExternalReferences(PsiMethod method, ArrayList<UsageInfo> result) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)method)) {
            PsiElement element = ref.getElement();
            PsiExpression qualifier = null;
            if (element instanceof PsiReferenceExpression && (qualifier = ((PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiThisExpression) {
                qualifier = null;
            }
            if (PsiTreeUtil.isAncestor(this.myMember, (PsiElement)element, (boolean)true) && qualifier == null) continue;
            result.add(new UsageInfo(element));
        }
    }

    protected void setupTypeParameterList() throws IncorrectOperationException {
        PsiTypeParameterList list = this.myMember.getTypeParameterList();
        assert (list != null);
        PsiTypeParameterList newList = RefactoringUtil.createTypeParameterListWithUsedTypeParameters(new PsiElement[]{this.myMember});
        if (newList != null) {
            list.replace((PsiElement)newList);
        }
    }

    protected boolean makeClassParameterFinal(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            InternalUsageInfo internalUsageInfo;
            PsiElement referencedElement;
            if (!(usage instanceof InternalUsageInfo) || (referencedElement = (internalUsageInfo = (InternalUsageInfo)usage).getReferencedElement()) instanceof PsiField && this.mySettings.getNameForField((PsiField)referencedElement) != null || !internalUsageInfo.isInsideAnonymous()) continue;
            return true;
        }
        return false;
    }

    protected static boolean makeFieldParameterFinal(PsiField field, UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            InternalUsageInfo internalUsageInfo;
            PsiElement referencedElement;
            if (!(usage instanceof InternalUsageInfo) || !((referencedElement = (internalUsageInfo = (InternalUsageInfo)usage).getReferencedElement()) instanceof PsiField) || !field.equals(referencedElement) || !internalUsageInfo.isInsideAnonymous()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"make.static.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName(this.myMember)});
    }

    public T getMember() {
        return this.myMember;
    }

    public Settings getSettings() {
        return this.mySettings;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        PsiManager manager = this.myMember.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        try {
            for (UsageInfo usage : usages) {
                if (usage instanceof SelfUsageInfo) {
                    this.changeSelfUsage((SelfUsageInfo)usage);
                    continue;
                }
                if (usage instanceof InternalUsageInfo) {
                    this.changeInternalUsage((InternalUsageInfo)usage, factory);
                    continue;
                }
                this.changeExternalUsage(usage, factory);
            }
            this.changeSelf(factory, usages);
        }
        catch (IncorrectOperationException ex) {
            LOG.assertTrue(false);
        }
    }

    protected abstract void changeSelf(PsiElementFactory var1, UsageInfo[] var2) throws IncorrectOperationException;

    protected abstract void changeSelfUsage(SelfUsageInfo var1) throws IncorrectOperationException;

    protected abstract void changeInternalUsage(InternalUsageInfo var1, PsiElementFactory var2) throws IncorrectOperationException;

    protected abstract void changeExternalUsage(UsageInfo var1, PsiElementFactory var2) throws IncorrectOperationException;
}

