/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners.impl.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RefactoringTransactionImpl
implements RefactoringTransaction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.listeners.impl.impl.RefactoringTransactionImpl");
    private final ArrayList<Runnable> myRunnables = new ArrayList();
    private final List<RefactoringElementListenerProvider> myListenerProviders;
    private final Map<PsiElement, ArrayList<RefactoringElementListener>> myOldElementToListenerListMap = new HashMap();
    private final Map<PsiElement, RefactoringElementListener> myOldElementToTransactionListenerMap = new HashMap();

    public RefactoringTransactionImpl(List<RefactoringElementListenerProvider> listenerProviders) {
        this.myListenerProviders = listenerProviders;
    }

    private void addAffectedElement(PsiElement oldElement) {
        if (this.myOldElementToListenerListMap.get(oldElement) != null) {
            return;
        }
        ArrayList<RefactoringElementListener> listenerList = new ArrayList<RefactoringElementListener>();
        for (RefactoringElementListenerProvider provider : this.myListenerProviders) {
            try {
                RefactoringElementListener listener = provider.getListener(oldElement);
                if (listener == null) continue;
                listenerList.add(listener);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myOldElementToListenerListMap.put(oldElement, listenerList);
    }

    @Override
    public RefactoringElementListener getElementListener(PsiElement oldElement) {
        RefactoringElementListener listener = this.myOldElementToTransactionListenerMap.get(oldElement);
        if (listener == null) {
            listener = new MyRefactoringElementListener(oldElement);
            this.myOldElementToTransactionListenerMap.put(oldElement, listener);
        }
        return listener;
    }

    @Override
    public void commit() {
        for (Runnable runnable : this.myRunnables) {
            runnable.run();
        }
    }

    private class MyRefactoringElementListener
    implements RefactoringElementListener,
    UndoRefactoringElementListener {
        private final ArrayList<RefactoringElementListener> myListenerList;

        private MyRefactoringElementListener(PsiElement oldElement) {
            RefactoringTransactionImpl.this.addAffectedElement(oldElement);
            this.myListenerList = (ArrayList)RefactoringTransactionImpl.this.myOldElementToListenerListMap.get(oldElement);
        }

        public void elementMoved(final @NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/listeners/impl/impl/RefactoringTransactionImpl$MyRefactoringElementListener", "elementMoved"));
            }
            RefactoringTransactionImpl.this.myRunnables.add(new Runnable(){

                @Override
                public void run() {
                    for (RefactoringElementListener refactoringElementListener : MyRefactoringElementListener.this.myListenerList) {
                        try {
                            refactoringElementListener.elementMoved(newElement);
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                    }
                }
            });
        }

        public void elementRenamed(final @NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/listeners/impl/impl/RefactoringTransactionImpl$MyRefactoringElementListener", "elementRenamed"));
            }
            RefactoringTransactionImpl.this.myRunnables.add(new Runnable(){

                @Override
                public void run() {
                    for (RefactoringElementListener refactoringElementListener : MyRefactoringElementListener.this.myListenerList) {
                        try {
                            refactoringElementListener.elementRenamed(newElement);
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                    }
                }
            });
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/listeners/impl/impl/RefactoringTransactionImpl$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/listeners/impl/impl/RefactoringTransactionImpl$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            for (RefactoringElementListener listener : this.myListenerList) {
                if (!(listener instanceof UndoRefactoringElementListener)) continue;
                ((UndoRefactoringElementListener)listener).undoElementMovedOrRenamed(newElement, oldQualifiedName);
            }
        }
    }
}

