/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaInplaceIntroducer
extends AbstractInplaceIntroducer<PsiVariable, PsiExpression> {
    protected TypeSelectorManagerImpl myTypeSelectorManager;

    public AbstractJavaInplaceIntroducer(Project project, Editor editor, PsiExpression expr, PsiVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, String title) {
        super(project, InjectedLanguageUtil.getTopLevelEditor(editor), (PsiElement)expr, (PsiNameIdentifierOwner)localVariable, (PsiElement[])occurrences, title, (FileType)StdFileTypes.JAVA);
        this.myTypeSelectorManager = typeSelectorManager;
    }

    protected abstract PsiVariable createFieldToStartTemplateOn(String[] var1, PsiType var2);

    protected abstract String[] suggestNames(PsiType var1, String var2);

    protected abstract VariableKind getVariableKind();

    @Override
    protected String[] suggestNames(boolean replaceAll, PsiVariable variable) {
        JavaCodeStyleManager javaCodeStyleManager;
        String paramName;
        int idx;
        this.myTypeSelectorManager.setAllOccurrences(replaceAll);
        PsiType defaultType = this.myTypeSelectorManager.getTypeSelector().getSelectedType();
        String propertyName = variable != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(variable.getName(), VariableKind.LOCAL_VARIABLE) : null;
        Object[] names = this.suggestNames(defaultType, propertyName);
        if (propertyName != null && names.length > 1 && (idx = ArrayUtil.find((Object[])names, (Object)(paramName = (javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject)).propertyNameToVariableName(propertyName, this.getVariableKind())))) > -1) {
            ArrayUtil.swap((Object[])names, (int)0, (int)idx);
        }
        return names;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        this.myTypeSelectorManager.setAllOccurrences(replaceAll);
        return this.createFieldToStartTemplateOn(names, this.getType());
    }

    @Override
    protected void correctExpression() {
        final PsiElement parent = ((PsiExpression)this.getExpr()).getParent();
        if (parent instanceof PsiExpressionStatement && parent.getLastChild() instanceof PsiErrorElement) {
            this.myExpr = ((PsiExpressionStatement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement>(){

                public PsiElement compute() {
                    return parent.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)AbstractJavaInplaceIntroducer.this.myProject).createStatementFromText(parent.getText() + ";", parent));
                }
            })).getExpression();
            this.myEditor.getCaretModel().moveToOffset(((PsiExpression)this.myExpr).getTextRange().getStartOffset());
        }
    }

    @Override
    public PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, RangeMarker marker, String exprText) {
        return AbstractJavaInplaceIntroducer.restoreExpression(containingFile, psiVariable, JavaPsiFacade.getElementFactory((Project)this.myProject), marker, exprText);
    }

    @Override
    protected void restoreState(PsiVariable psiField) {
        SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.getType());
        super.restoreState(psiField);
        for (PsiExpression occurrence : (PsiExpression[])this.myOccurrences) {
            if (occurrence.isValid()) continue;
            return;
        }
        try {
            this.myTypeSelectorManager = this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression)this.myExpr, (PsiExpression[])this.myOccurrences) : new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression[])this.myOccurrences);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/introduceParameter/AbstractJavaInplaceIntroducer", "saveSettings"));
        }
        TypeSelectorManagerImpl.typeSelected(psiVariable.getType(), this.getType());
        this.myTypeSelectorManager = null;
    }

    public PsiType getType() {
        return this.myTypeSelectorManager.getDefaultType();
    }

    public static String[] appendUnresolvedExprName(String[] names, PsiExpression expr) {
        if (expr instanceof PsiReferenceExpression && ((PsiReferenceExpression)expr).resolve() == null) {
            String name = expr.getText();
            if (JavaPsiFacade.getInstance((Project)expr.getProject()).getNameHelper().isIdentifier(name, LanguageLevel.HIGHEST)) {
                names = ArrayUtil.mergeArrays((String[])new String[]{name}, (String[])names);
            }
        }
        return names;
    }

    @Nullable
    public static PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, PsiElementFactory elementFactory, RangeMarker marker, String exprText) {
        PsiExpression expression;
        if (exprText == null) {
            return null;
        }
        if (psiVariable == null || !psiVariable.isValid()) {
            return null;
        }
        PsiElement refVariableElement = containingFile.findElementAt(marker.getStartOffset());
        PsiElement refVariableElementParent = refVariableElement != null ? refVariableElement.getParent() : null;
        Object object = expression = refVariableElement instanceof PsiKeyword && refVariableElementParent instanceof PsiNewExpression ? (PsiNewExpression)refVariableElementParent : (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class);
        if (expression instanceof PsiReferenceExpression && !(expression.getParent() instanceof PsiMethodCallExpression)) {
            String referenceName = ((PsiReferenceExpression)expression).getReferenceName();
            if (((PsiReferenceExpression)expression).resolve() == psiVariable || Comparing.strEqual((String)psiVariable.getName(), (String)referenceName) || Comparing.strEqual((String)exprText, (String)referenceName)) {
                return (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(exprText, (PsiElement)psiVariable));
            }
        }
        if (expression == null) {
            expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiExpression.class);
        }
        while (expression instanceof PsiReferenceExpression || expression instanceof PsiMethodCallExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodCallExpression && parent.getText().equals(exprText)) {
                return (PsiExpression)parent;
            }
            if (parent instanceof PsiExpression) {
                expression = (PsiExpression)parent;
                if (!expression.getText().equals(exprText)) continue;
                return expression;
            }
            if (!(expression instanceof PsiReferenceExpression)) break;
            return null;
        }
        if (expression != null && expression.isValid() && expression.getText().equals(exprText)) {
            return expression;
        }
        if (refVariableElementParent instanceof PsiExpression && refVariableElementParent.getText().equals(exprText)) {
            return (PsiExpression)refVariableElementParent;
        }
        return null;
    }

    public static Expression createExpression(final TypeExpression expression, final String defaultType) {
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(defaultType);
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return new TextResult(defaultType);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return expression.calculateLookupItems(context);
            }

            public String getAdvertisingText() {
                return null;
            }
        };
    }
}

