/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class InlineSuperClassRefactoringDialog
extends InlineOptionsDialog {
    private final PsiClass mySuperClass;
    private final PsiClass myCurrentInheritor;
    private final PsiClass[] myTargetClasses;
    private final DocCommentPanel myDocPanel;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project, PsiClass superClass, PsiClass currentInheritor, PsiClass ... targetClasses) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog", "<init>"));
        }
        super(project, false, (PsiElement)superClass);
        this.mySuperClass = superClass;
        this.myCurrentInheritor = currentInheritor;
        this.myInvokedOnReference = currentInheritor != null;
        this.myTargetClasses = targetClasses;
        this.myDocPanel = new DocCommentPanel("JavaDoc for inlined members");
        this.myDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        this.init();
        this.setTitle("Inline Super Class");
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_SUPER_CLASS_THIS = this.isInlineThisOnly();
        }
        this.invokeRefactoring(new InlineSuperClassRefactoringProcessor(this.getProject(), this.isInlineThisOnly() ? this.myCurrentInheritor : null, this.mySuperClass, this.myDocPanel.getPolicy(), this.myTargetClasses));
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Override
    protected JComponent createCenterPanel() {
        JLabel label = new JLabel("<html>Super class '" + this.mySuperClass.getQualifiedName() + "' inheritors: " + (this.myTargetClasses.length > 1 ? " <br>&nbsp;&nbsp;&nbsp;'" : "'") + StringUtil.join((Object[])this.myTargetClasses, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getQualifiedName();
            }
        }, (String)"',<br>&nbsp;&nbsp;&nbsp;'") + "'</html>");
        label.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)this.myDocPanel, gc);
        panel.add((Component)label, gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add((Component)super.createCenterPanel(), gc);
        return panel;
    }

    @Override
    protected String getNameLabelText() {
        return "Class " + this.mySuperClass.getQualifiedName();
    }

    @Override
    protected String getBorderTitle() {
        return "Inline";
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.super.class");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.super.class");
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_SUPER_CLASS_THIS;
    }
}

