/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InputVariables {
    private final List<VariableData> myInputVariables;
    private List<? extends PsiVariable> myInitialParameters;
    private final Project myProject;
    private final LocalSearchScope myScope;
    private ParametersFolder myFolding;
    private boolean myFoldingAvailable;

    public InputVariables(List<? extends PsiVariable> inputVariables, Project project, LocalSearchScope scope, boolean foldingAvailable) {
        this.myInitialParameters = inputVariables;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding = new ParametersFolder();
        this.myInputVariables = this.wrapInputVariables(inputVariables);
    }

    public InputVariables(List<VariableData> inputVariables, Project project, LocalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myInputVariables = new ArrayList<VariableData>(inputVariables);
    }

    public boolean isFoldable() {
        return this.myFolding.isFoldable();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<VariableData> wrapInputVariables(List<? extends PsiVariable> inputVariables) {
        ArrayList<VariableData> inputData = new ArrayList<VariableData>(inputVariables.size());
        for (PsiVariable psiVariable : inputVariables) {
            PsiType type;
            String name = psiVariable.getName();
            if (!(psiVariable instanceof PsiParameter)) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                VariableKind kind = codeStyleManager.getVariableKind(psiVariable);
                name = codeStyleManager.variableNameToPropertyName(name, kind);
                name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            }
            if ((type = psiVariable.getType()) instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            HashMap<PsiCodeBlock, PsiType> casts = new HashMap<PsiCodeBlock, PsiType>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)this.myScope)) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class);
                if (parent instanceof PsiTypeCastExpression) {
                    PsiType currentType = (PsiType)casts.get(block);
                    PsiType castType = ((PsiTypeCastExpression)parent).getType();
                    casts.put(block, casts.containsKey(block) && currentType == null ? null : InputVariables.getBroaderType(currentType, castType));
                    continue;
                }
                casts.put(block, null);
            }
            if (!casts.containsValue(null)) {
                PsiType psiType;
                PsiType currentType = null;
                Iterator i$ = casts.values().iterator();
                while (i$.hasNext() && (currentType = InputVariables.getBroaderType(currentType, psiType = (PsiType)i$.next())) != null) {
                }
                if (currentType != null && (currentType = this.checkTopLevelInstanceOf(currentType)) != null) {
                    type = currentType;
                }
            }
            VariableData data = new VariableData(psiVariable, type);
            data.name = name;
            data.passAsParameter = true;
            inputData.add(data);
            if (!this.myFoldingAvailable) continue;
            this.myFolding.isParameterFoldable(data, this.myScope, inputVariables);
        }
        if (this.myFoldingAvailable) {
            void var4_6;
            HashSet<VariableData> toDelete = new HashSet<VariableData>();
            int n = inputData.size() - 1;
            while (var4_6 >= 0) {
                VariableData data = inputData.get((int)var4_6);
                if (this.myFolding.isParameterSafeToDelete(data, this.myScope)) {
                    toDelete.add(data);
                }
                --var4_6;
            }
            inputData.removeAll(toDelete);
        }
        return inputData;
    }

    @Nullable
    private PsiType checkTopLevelInstanceOf(final PsiType currentType) {
        PsiExpression condition;
        PsiElement[] scope = this.myScope.getScope();
        if (scope.length == 1 && scope[0] instanceof PsiIfStatement && (condition = ((PsiIfStatement)scope[0]).getCondition()) != null) {
            class CheckInstanceOf {
                CheckInstanceOf() {
                }

                boolean check(PsiInstanceOfExpression expr) {
                    PsiTypeElement checkType = expr.getCheckType();
                    return checkType == null || !checkType.getType().equals(currentType);
                }
            }
            CheckInstanceOf checker = new CheckInstanceOf();
            PsiInstanceOfExpression[] expressions = (PsiInstanceOfExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)condition, PsiInstanceOfExpression.class);
            if (expressions != null) {
                for (PsiInstanceOfExpression instanceOfExpression : expressions) {
                    if (checker.check(instanceOfExpression)) continue;
                    return null;
                }
            } else if (condition instanceof PsiInstanceOfExpression && !checker.check((PsiInstanceOfExpression)condition)) {
                return null;
            }
        }
        return currentType;
    }

    @Nullable
    private static PsiType getBroaderType(PsiType currentType, PsiType castType) {
        if (currentType != null) {
            if (castType != null) {
                if (TypeConversionUtil.isAssignable((PsiType)castType, (PsiType)currentType)) {
                    return castType;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)castType)) {
                    for (PsiType superType : castType.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)currentType)) continue;
                        return superType;
                    }
                    return null;
                }
            }
        } else {
            return castType;
        }
        return currentType;
    }

    public List<VariableData> getInputVariables() {
        return this.myInputVariables;
    }

    public PsiExpression replaceWrappedReferences(PsiElement[] elements, PsiExpression expression) {
        if (!this.myFoldingAvailable) {
            return expression;
        }
        boolean update = elements[0] == expression;
        for (VariableData inputVariable : this.myInputVariables) {
            this.myFolding.foldParameterUsagesInBody(inputVariable, elements, (SearchScope)this.myScope);
        }
        return update ? (PsiExpression)elements[0] : expression;
    }

    public boolean toDeclareInsideBody(PsiVariable variable) {
        ArrayList<VariableData> knownVars = new ArrayList<VariableData>(this.myInputVariables);
        for (VariableData data : knownVars) {
            if (!data.variable.equals(variable)) continue;
            return false;
        }
        return !this.myFolding.wasExcluded(variable);
    }

    public boolean contains(PsiVariable variable) {
        for (VariableData data : this.myInputVariables) {
            if (!data.variable.equals(variable)) continue;
            return true;
        }
        return false;
    }

    public void removeParametersUsedInExitsOnly(PsiElement codeFragment, Collection<PsiStatement> exitStatements, ControlFlow controlFlow, int startOffset, int endOffset) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<VariableData> iterator = this.myInputVariables.iterator();
        block0: while (iterator.hasNext()) {
            VariableData data = iterator.next();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
                PsiElement element = ref.getElement();
                int elementOffset = controlFlow.getStartOffset(element);
                if (elementOffset < startOffset || elementOffset > endOffset || InputVariables.isInExitStatements(element, exitStatements)) continue;
                continue block0;
            }
            iterator.remove();
        }
    }

    private static boolean isInExitStatements(PsiElement element, Collection<PsiStatement> exitStatements) {
        for (PsiStatement exitStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)exitStatement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public InputVariables copy() {
        InputVariables inputVariables = new InputVariables(this.myInputVariables, this.myProject, this.myScope);
        inputVariables.myFoldingAvailable = this.myFoldingAvailable;
        inputVariables.myFolding = this.myFolding;
        inputVariables.myInitialParameters = this.myInitialParameters;
        return inputVariables;
    }

    public void appendCallArguments(VariableData data, StringBuilder buffer) {
        if (this.myFoldingAvailable) {
            buffer.append(this.myFolding.getGeneratedCallArgument(data));
        } else {
            if (!TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)data.variable.getType())) {
                buffer.append("(").append(data.type.getCanonicalText()).append(")");
            }
            buffer.append(data.variable.getName());
        }
    }

    public void setFoldingAvailable(boolean foldingAvailable) {
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding.clear();
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public void annotateWithParameter(PsiJavaCodeReferenceElement reference) {
        for (VariableData data : this.myInputVariables) {
            PsiMethod psiMethod;
            int idx;
            PsiElement element = reference.resolve();
            if (!data.variable.equals(element)) continue;
            PsiType type = data.variable.getType();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (idx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)reference)) > -1 && (psiMethod = methodCallExpression.resolveMethod()) != null) {
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                if (idx >= parameters.length && (idx = parameters.length - 1) >= 0) {
                    type = parameters[idx].getType();
                }
                if (type instanceof PsiEllipsisType) {
                    type = ((PsiEllipsisType)type).getComponentType();
                }
            }
            if (this.myFoldingAvailable && this.myFolding.annotateWithParameter(data, (PsiElement)reference)) continue;
            reference.putUserData(DuplicatesFinder.PARAMETER, (Object)Pair.create((Object)data.variable, (Object)type));
        }
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFolding.isFoldingSelectedByDefault();
    }
}

