/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.JavaComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodDialog
extends AbstractExtractDialog {
    public static final String EXTRACT_METHOD_DEFAULT_VISIBILITY = "extract.method.default.visibility";
    private final Project myProject;
    private final PsiType myReturnType;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiType[] myExceptions;
    private final boolean myStaticFlag;
    private boolean myCanBeStatic;
    private final PsiElement[] myElementsToExtract;
    private final String myHelpId;
    private final EditorTextField myNameField;
    private final MethodSignatureComponent mySignature;
    private final JCheckBox myMakeStatic;
    protected JCheckBox myMakeVarargs;
    private JCheckBox myCbChainedConstructor;
    private final InputVariables myVariableData;
    private final PsiClass myTargetClass;
    private ComboBoxVisibilityPanel<String> myVisibilityPanel;
    private boolean myDefaultVisibility = true;
    private boolean myChangingVisibility;
    private final JCheckBox myFoldParameters = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.folded.parameters"));
    public JPanel myCenterPanel;
    public JPanel myParamTable;
    private VariableData[] myInputVariables;

    public ExtractMethodDialog(Project project, PsiClass targetClass, InputVariables inputVariables, PsiType returnType, PsiTypeParameterList typeParameterList, PsiType[] exceptions, boolean isStatic, boolean canBeStatic, boolean canBeChainedConstructor, String initialMethodName, String title, String helpId, PsiElement[] elementsToExtract) {
        super(project);
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myReturnType = returnType;
        this.myTypeParameterList = typeParameterList;
        this.myExceptions = exceptions;
        this.myStaticFlag = isStatic;
        this.myCanBeStatic = canBeStatic;
        this.myElementsToExtract = elementsToExtract;
        this.myVariableData = inputVariables;
        this.myHelpId = helpId;
        this.mySignature = new MethodSignatureComponent("", project, (FileType)JavaFileType.INSTANCE);
        this.mySignature.setPreferredSize(new Dimension(500, 100));
        this.mySignature.setMinimumSize(new Dimension(500, 100));
        this.setTitle(title);
        this.myNameField = this.createNameField(initialMethodName);
        int height = this.myVariableData.getInputVariables().size() + 2;
        if (this.myExceptions.length > 0) {
            height += this.myExceptions.length + 1;
        }
        this.myMakeStatic = new NonFocusableCheckBox();
        this.myMakeStatic.setText(RefactoringBundle.message((String)"declare.static.checkbox"));
        if (canBeChainedConstructor) {
            this.myCbChainedConstructor = new NonFocusableCheckBox(RefactoringBundle.message((String)"extract.chained.constructor.checkbox"));
        }
        this.init();
    }

    protected EditorTextField createNameField(String initialMethodName) {
        EditorTextField field = new EditorTextField(initialMethodName);
        field.selectAll();
        return field;
    }

    protected boolean areTypesDirected() {
        return true;
    }

    @Override
    public boolean isMakeStatic() {
        if (this.myStaticFlag) {
            return true;
        }
        return this.myCanBeStatic && this.myMakeStatic.isSelected();
    }

    @Override
    public boolean isChainedConstructor() {
        return this.myCbChainedConstructor != null && this.myCbChainedConstructor.isSelected();
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myHelpId != null) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractMethodDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractMethodDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    public String getChosenMethodName() {
        return this.myNameField.getText();
    }

    @Override
    public VariableData[] getChosenParameters() {
        return this.myInputVariables;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doOKAction() {
        PsiMethod containingMethod;
        MultiMap conflicts = new MultiMap();
        this.checkMethodConflicts((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.close(1);
                }
                return;
            }
        }
        if (this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
            VariableData data = this.myInputVariables[this.myInputVariables.length - 1];
            if (data.type instanceof PsiArrayType) {
                data.type = new PsiEllipsisType(((PsiArrayType)data.type).getComponentType());
            }
        }
        if ((containingMethod = this.getContainingMethod()) != null && containingMethod.hasModifierProperty("public")) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(EXTRACT_METHOD_DEFAULT_VISIBILITY, this.getVisibility());
        }
        super.doOKAction();
    }

    protected JComponent createNorthPanel() {
        JPanel main = new JPanel(new BorderLayout());
        JPanel namePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 2, true, false));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(RefactoringBundle.message((String)"changeSignature.name.prompt"));
        namePanel.add(nameLabel);
        namePanel.add((Component)((Object)this.myNameField));
        nameLabel.setLabelFor((Component)((Object)this.myNameField));
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ExtractMethodDialog.this.update();
            }
        });
        this.myVisibilityPanel = this.createVisibilityPanel();
        JPanel visibilityAndName = new JPanel(new BorderLayout(2, 0));
        visibilityAndName.add(this.myVisibilityPanel, "West");
        visibilityAndName.add((Component)namePanel, "Center");
        main.add((Component)visibilityAndName, "Center");
        this.setOKActionEnabled(false);
        this.setOKActionEnabled(JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(this.myNameField.getText()));
        JPanel options = new JPanel(new BorderLayout());
        options.add((Component)this.createOptionsPanel(), "West");
        main.add((Component)options, "South");
        return main;
    }

    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 5));
        if (this.myStaticFlag || this.myCanBeStatic) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag);
            this.myMakeStatic.setSelected(this.myStaticFlag);
            this.myMakeStatic.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            optionsPanel.add(this.myMakeStatic);
        } else {
            this.myMakeStatic.setSelected(false);
            this.myMakeStatic.setEnabled(false);
        }
        Border emptyBorder = IdeBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)4);
        this.myMakeStatic.setBorder(emptyBorder);
        this.myFoldParameters.setSelected(this.myVariableData.isFoldingSelectedByDefault());
        this.myFoldParameters.setVisible(this.myVariableData.isFoldable());
        this.myVariableData.setFoldingAvailable(this.myFoldParameters.isSelected());
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[this.myVariableData.getInputVariables().size()]);
        this.myFoldParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodDialog.this.myVariableData.setFoldingAvailable(ExtractMethodDialog.this.myFoldParameters.isSelected());
                ExtractMethodDialog.access$302(ExtractMethodDialog.this, ExtractMethodDialog.this.myVariableData.getInputVariables().toArray(new VariableData[ExtractMethodDialog.this.myVariableData.getInputVariables().size()]));
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.createParametersPanel();
                ExtractMethodDialog.this.updateSignature();
            }
        });
        optionsPanel.add(this.myFoldParameters);
        this.myFoldParameters.setBorder(emptyBorder);
        boolean canBeVarargs = false;
        for (VariableData data : this.myInputVariables) {
            canBeVarargs |= data.type instanceof PsiArrayType;
        }
        if (this.myVariableData.isFoldable()) {
            canBeVarargs |= this.myVariableData.isFoldingSelectedByDefault();
        }
        if (canBeVarargs) {
            this.myMakeVarargs = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.varargs.checkbox"));
            this.myMakeVarargs.setBorder(emptyBorder);
            this.updateVarargsEnabled();
            this.myMakeVarargs.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtractMethodDialog.this.updateSignature();
                }
            });
            this.myMakeVarargs.setSelected(false);
            optionsPanel.add(this.myMakeVarargs);
        }
        if (this.myCbChainedConstructor != null) {
            optionsPanel.add(this.myCbChainedConstructor);
            this.myCbChainedConstructor.setBorder(emptyBorder);
            this.myCbChainedConstructor.addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExtractMethodDialog.this.myDefaultVisibility) {
                        ExtractMethodDialog.this.myChangingVisibility = true;
                        try {
                            if (ExtractMethodDialog.this.isChainedConstructor()) {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility(VisibilityUtil.getVisibilityModifier((PsiModifierList)ExtractMethodDialog.this.myTargetClass.getModifierList()));
                            } else {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility("private");
                            }
                        }
                        finally {
                            ExtractMethodDialog.this.myChangingVisibility = false;
                        }
                    }
                    ExtractMethodDialog.this.update();
                }
            });
        }
        return optionsPanel;
    }

    private ComboBoxVisibilityPanel<String> createVisibilityPanel() {
        JavaComboBoxVisibilityPanel panel = new JavaComboBoxVisibilityPanel();
        PsiMethod containingMethod = this.getContainingMethod();
        panel.setVisibility(containingMethod != null && containingMethod.hasModifierProperty("public") ? PropertiesComponent.getInstance((Project)this.myProject).getOrInit(EXTRACT_METHOD_DEFAULT_VISIBILITY, "private") : "private");
        panel.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExtractMethodDialog.this.updateSignature();
                if (!ExtractMethodDialog.this.myChangingVisibility) {
                    ExtractMethodDialog.this.myDefaultVisibility = false;
                }
            }
        });
        return panel;
    }

    private PsiMethod getContainingMethod() {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])this.myElementsToExtract), PsiMethod.class);
    }

    private void updateVarargsEnabled() {
        if (this.myMakeVarargs != null) {
            this.myMakeVarargs.setEnabled(this.myInputVariables[this.myInputVariables.length - 1].type instanceof PsiArrayType);
        }
    }

    private void update() {
        this.myNameField.setEnabled(!this.isChainedConstructor());
        if (this.myMakeStatic != null) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag && this.myCanBeStatic && !this.isChainedConstructor());
        }
        this.updateSignature();
        this.setOKActionEnabled(JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(this.myNameField.getText()) || this.isChainedConstructor());
    }

    @Override
    public String getVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.createParametersPanel();
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)this.myCenterPanel);
        splitter.setSecondComponent(this.createSignaturePanel());
        return splitter;
    }

    protected boolean isOutputVariable(PsiVariable var) {
        return false;
    }

    protected void createParametersPanel() {
        if (this.myParamTable != null) {
            this.myCenterPanel.remove(this.myParamTable);
        }
        this.myParamTable = this.createParameterTableComponent();
        this.myParamTable.setMinimumSize(new Dimension(500, 100));
        this.myCenterPanel.add((Component)this.myParamTable, "Center");
        final JTable table = (JTable)UIUtil.findComponentOfType((JComponent)this.myParamTable, JTable.class);
        this.myCenterPanel.add((Component)SeparatorFactory.createSeparator((String)"&Parameters", (JComponent)table), "North");
        if (table != null) {
            table.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (table.getRowCount() > 0) {
                        int col = table.getSelectedColumn();
                        int row = table.getSelectedRow();
                        if (col == -1 || row == -1) {
                            table.getSelectionModel().setSelectionInterval(0, 0);
                            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                }
            });
        }
    }

    protected ParameterTablePanel createParameterTableComponent() {
        return new ParameterTablePanel(this.myProject, this.myInputVariables, this.myElementsToExtract){

            @Override
            protected void updateSignature() {
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.updateSignature();
            }

            @Override
            protected void doEnterAction() {
                ExtractMethodDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                ExtractMethodDialog.this.doCancelAction();
            }

            @Override
            protected boolean areTypesDirected() {
                return ExtractMethodDialog.this.areTypesDirected();
            }

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ExtractMethodDialog.this.isOutputVariable(variable);
            }
        };
    }

    protected JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), null), "North");
        panel.add((Component)((Object)this.mySignature), "Center");
        this.updateSignature();
        return panel;
    }

    protected void updateSignature() {
        if (this.mySignature != null) {
            this.mySignature.setSignature(this.getSignature());
        }
    }

    protected String getSignature() {
        String typeParamsText;
        StringBuilder buffer = new StringBuilder();
        String visibilityString = VisibilityUtil.getVisibilityString((String)this.myVisibilityPanel.getVisibility());
        buffer.append(visibilityString);
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (this.isMakeStatic() && !this.isChainedConstructor()) {
            buffer.append("static ");
        }
        if (this.myTypeParameterList != null && !(typeParamsText = this.myTypeParameterList.getText()).isEmpty()) {
            buffer.append(typeParamsText);
            buffer.append(" ");
        }
        if (this.isChainedConstructor()) {
            buffer.append(this.myTargetClass.getName());
        } else {
            buffer.append(PsiFormatUtil.formatType((PsiType)this.myReturnType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(this.myNameField.getText());
        }
        buffer.append("(");
        String INDENT = StringUtil.repeatSymbol((char)' ', (int)buffer.length());
        VariableData[] datas = this.myInputVariables;
        int count = 0;
        for (int i = 0; i < datas.length; ++i) {
            VariableData data = datas[i];
            if (!data.passAsParameter) continue;
            PsiType type = data.type;
            if (i == datas.length - 1 && type instanceof PsiArrayType && this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
            String typeText = type.getPresentableText();
            if (count > 0) {
                buffer.append(",\n");
                buffer.append(INDENT);
            }
            buffer.append(typeText);
            buffer.append(" ");
            buffer.append(data.name);
            ++count;
        }
        buffer.append(")");
        if (this.myExceptions.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiType exception : this.myExceptions) {
                buffer.append(INDENT);
                buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    protected String getDimensionServiceKey() {
        return "extract.method.dialog";
    }

    protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiMethod prototype;
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            prototype = factory.createMethod(this.myNameField.getText().trim(), this.myReturnType);
            if (this.myTypeParameterList != null) {
                prototype.getTypeParameterList().replace((PsiElement)this.myTypeParameterList);
            }
            for (VariableData data : this.myInputVariables) {
                if (!data.passAsParameter) continue;
                prototype.getParameterList().add((PsiElement)factory.createParameter(data.name, data.type));
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)"private", (boolean)true);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(this.myTargetClass, null, prototype, conflicts);
    }

    static /* synthetic */ VariableData[] access$302(ExtractMethodDialog x0, VariableData[] x1) {
        x0.myInputVariables = x1;
        return x1;
    }
}

