/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptorImpl
implements FieldDescriptor {
    private PsiField myField;
    private final String myGetterName;
    private final String mySetterName;
    private final PsiMethod myGetterPrototype;
    private final PsiMethod mySetterPrototype;

    public FieldDescriptorImpl(@NotNull PsiField field, @NotNull String getterName, @NotNull String setterName, @Nullable PsiMethod getterPrototype, @Nullable PsiMethod setterPrototype) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "<init>"));
        }
        if (getterName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "<init>"));
        }
        if (setterName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "<init>"));
        }
        this.myField = field;
        this.myGetterName = getterName;
        this.mySetterName = setterName;
        this.myGetterPrototype = getterPrototype;
        this.mySetterPrototype = setterPrototype;
    }

    @NotNull
    public PsiField getField() {
        PsiField psiField = this.myField;
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "getField"));
        }
        return psiField;
    }

    @NotNull
    public String getGetterName() {
        String string = this.myGetterName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "getGetterName"));
        }
        return string;
    }

    @NotNull
    public String getSetterName() {
        String string = this.mySetterName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "getSetterName"));
        }
        return string;
    }

    @Nullable
    public PsiMethod getGetterPrototype() {
        return this.myGetterPrototype;
    }

    @Nullable
    public PsiMethod getSetterPrototype() {
        return this.mySetterPrototype;
    }

    public void refreshField(@NotNull PsiField newField) {
        if (newField == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/encapsulateFields/FieldDescriptorImpl", "refreshField"));
        }
        this.myField = newField;
    }
}

