/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CopyClassDialog
extends DialogWrapper {
    @NonNls
    private static final String RECENTS_KEY = "CopyClassDialog.RECENTS_KEY";
    private final JLabel myInformationLabel = new JLabel();
    private EditorTextField myNameField;
    private final JLabel myPackageLabel = new JLabel();
    private ReferenceEditorComboWithBrowseButton myTfPackage;
    private final Project myProject;
    private final boolean myDoClone;
    private final PsiDirectory myDefaultTargetDirectory;
    private final JCheckBox myOpenInEditorCb = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
    private final DestinationFolderComboBox myDestinationCB = new DestinationFolderComboBox(){

        @Override
        public String getTargetPackage() {
            return CopyClassDialog.this.myTfPackage.getText().trim();
        }

        @Override
        protected boolean reportBaseInTestSelectionInSource() {
            return true;
        }
    };
    protected MoveDestination myDestination;

    public CopyClassDialog(PsiClass aClass, PsiDirectory defaultTargetDirectory, Project project, boolean doClone) {
        super(project, true);
        this.myProject = project;
        this.myDefaultTargetDirectory = defaultTargetDirectory;
        this.myDoClone = doClone;
        String text = this.myDoClone ? RefactoringBundle.message((String)"copy.class.clone.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)}) : RefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)});
        this.myInformationLabel.setText(text);
        this.myInformationLabel.setFont(this.myInformationLabel.getFont().deriveFont(1));
        this.init();
        this.myDestinationCB.setData(this.myProject, defaultTargetDirectory, new Pass<String>(){

            public void pass(String s) {
                CopyClassDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.myTfPackage.getChildComponent());
        this.myNameField.setText(UsageViewUtil.getShortName((PsiElement)aClass));
        this.myNameField.selectAll();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/copy/CopyClassDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new EditorTextField("");
        String qualifiedName = this.getQualifiedName();
        this.myTfPackage = new PackageNameReferenceEditorCombo(qualifiedName, this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        this.myTfPackage.setTextFieldPreferredWidth(Math.max(qualifiedName.length() + 5, 40));
        this.myPackageLabel.setText(RefactoringBundle.message((String)"destination.package"));
        this.myPackageLabel.setLabelFor((Component)((Object)this.myTfPackage));
        if (this.myDoClone) {
            this.myTfPackage.setVisible(false);
            this.myPackageLabel.setVisible(false);
        }
        JLabel label = new JLabel(RefactoringBundle.message((String)"target.destination.folder"));
        boolean isMultipleSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject).size() > 1;
        this.myDestinationCB.setVisible(!this.myDoClone && isMultipleSourceRoots);
        label.setVisible(!this.myDoClone && isMultipleSourceRoots);
        label.setLabelFor((Component)((Object)this.myDestinationCB));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myOpenInEditorCb, "East");
        return FormBuilder.createFormBuilder().addComponent((JComponent)this.myInformationLabel).addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)((Object)this.myNameField), 12).addLabeledComponent((JComponent)this.myPackageLabel, (JComponent)((Object)this.myTfPackage)).addLabeledComponent((JComponent)label, (JComponent)((Object)this.myDestinationCB)).addComponent((JComponent)panel).getPanel();
    }

    protected String getQualifiedName() {
        PsiPackage aPackage;
        String qualifiedName = "";
        if (this.myDefaultTargetDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(this.myDefaultTargetDirectory)) != null) {
            qualifiedName = aPackage.getQualifiedName();
        }
        return qualifiedName;
    }

    public MoveDestination getTargetDirectory() {
        return this.myDestination;
    }

    public String getClassName() {
        return this.myNameField.getText();
    }

    public boolean openInEditor() {
        return this.myOpenInEditorCb.isSelected();
    }

    protected void doOKAction() {
        String packageName = this.myTfPackage.getText();
        String className = this.getClassName();
        String[] errorString = new String[1];
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper();
        if (packageName.length() > 0 && !nameHelper.isQualifiedName(packageName)) {
            errorString[0] = RefactoringBundle.message((String)"invalid.target.package.name.specified");
        } else if (className != null && className.isEmpty()) {
            errorString[0] = RefactoringBundle.message((String)"no.class.name.specified");
        } else {
            if (!nameHelper.isIdentifier(className)) {
                errorString[0] = RefactoringMessageUtil.getIncorrectIdentifierMessage(className);
            } else if (!this.myDoClone) {
                try {
                    PackageWrapper targetPackage = new PackageWrapper(manager, packageName);
                    this.myDestination = this.myDestinationCB.selectDirectory(targetPackage, false);
                    if (this.myDestination == null) {
                        return;
                    }
                }
                catch (IncorrectOperationException e) {
                    errorString[0] = e.getMessage();
                }
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.myNameField.requestFocusInWindow();
            return;
        }
        CopyFilesOrDirectoriesDialog.saveOpenInEditorState(this.myOpenInEditorCb.isSelected());
        super.doOKAction();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.copyClass");
    }
}

