/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.MethodSignatureEditor;
import com.intellij.refactoring.changeSignature.ParameterIndexer;
import org.jetbrains.annotations.NotNull;

public class JavaMethodSignatureEditor
extends MethodSignatureEditor<PsiMethod> {
    public JavaMethodSignatureEditor(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/JavaMethodSignatureEditor", "<init>"));
        }
        super(method, PsiMethod.class);
    }

    @Override
    public TextRange getSignatureTextRange() {
        PsiMethod method = (PsiMethod)this.getMethod();
        TextRange methodTextRange = method.getTextRange();
        TextRange paramsRange = method.getParameterList().getTextRange();
        return TextRange.create((int)methodTextRange.getStartOffset(), (int)paramsRange.getEndOffset());
    }

    @Override
    protected void indexParameters(PsiMethod method, @NotNull ParameterIndexer indexer) {
        if (indexer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/changeSignature/JavaMethodSignatureEditor", "indexParameters"));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            indexer.setIndex((PsiElement)parameters[i], i);
        }
    }

    @Override
    protected String formatMethod() {
        StringBuilder buffer = new StringBuilder();
        PsiMethod method = (PsiMethod)this.getMethod();
        PsiModifierList modifierList = method.getModifierList();
        String modifiers = modifierList.getText();
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        if (!method.isConstructor()) {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                buffer.append(returnType.getPresentableText());
            }
            buffer.append(" ");
        }
        buffer.append(method.getName());
        buffer.append("(");
        String indent = "    ";
        PsiParameter[] items = method.getParameterList().getParameters();
        for (int i = 0; i < items.length; ++i) {
            PsiParameter item = items[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("\n");
            buffer.append("    ");
            buffer.append(item.getTypeElement().getType().getPresentableText());
            buffer.append(" ");
            buffer.append(item.getName());
        }
        if (items.length != 0) {
            buffer.append("\n");
        }
        buffer.append(")");
        PsiClassType[] thrownExceptionsFragments = method.getThrowsList().getReferencedTypes();
        if (thrownExceptionsFragments.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (int i = 0; i < thrownExceptionsFragments.length; ++i) {
                String text = thrownExceptionsFragments[i].getPresentableText();
                buffer.append("    ");
                buffer.append(text);
                if (i >= thrownExceptionsFragments.length - 1) continue;
                buffer.append(",");
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

