/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderHandler;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithBuilderAction
extends BaseRefactoringAction {
    @Override
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "isAvailableOnElementInEditorAndFile"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        PsiClass psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(elementAt);
        return psiClass != null && psiClass.getConstructors().length > 0;
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "isEnabledOnElements"));
        }
        return false;
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ReplaceConstructorWithBuilderAction", "getHandler"));
        }
        return new ReplaceConstructorWithBuilderHandler();
    }
}

