/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.ide.actions.CopyElementAction;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringQuickListPopupAction
extends QuickSwitchSchemeAction {
    protected void fillActions(@Nullable Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "fillActions"));
        }
        if (project == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction("RefactoringMenu");
        RefactoringQuickListPopupAction.collectEnabledChildren(action, group, dataContext, actionManager, false);
    }

    private static void collectEnabledChildren(AnAction action, @NotNull DefaultActionGroup destinationGroup, @NotNull DataContext dataContext, @NotNull ActionManager actionManager, boolean popup) {
        if (destinationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (action instanceof DefaultActionGroup) {
            AnAction[] children;
            for (AnAction child : children = ((DefaultActionGroup)action).getChildren(null)) {
                if (child instanceof DefaultActionGroup) {
                    boolean isPopup = ((DefaultActionGroup)child).isPopup();
                    if (isPopup) {
                        destinationGroup.add((AnAction)new Separator(child.getTemplatePresentation().getText()));
                    }
                    RefactoringQuickListPopupAction.collectEnabledChildren(child, destinationGroup, dataContext, actionManager, isPopup || popup);
                    if (!isPopup) continue;
                    destinationGroup.add((AnAction)Separator.getInstance());
                    continue;
                }
                if (child instanceof Separator && !popup) {
                    destinationGroup.add(child);
                    continue;
                }
                if ((!(child instanceof BaseRefactoringAction) || !((BaseRefactoringAction)child).hasAvailableHandler(dataContext)) && !(child instanceof CopyElementAction)) continue;
                Presentation presentation = new Presentation();
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", presentation, actionManager, 0);
                child.update(event);
                if (!presentation.isEnabled() || !presentation.isVisible()) continue;
                destinationGroup.add(child);
            }
        }
    }

    protected void showPopup(AnActionEvent e, ListPopup popup) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            super.showPopup(e, popup);
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setVisible(e.getPlace() == "MainMenu" || e.getPlace() == "ActionPlace.QuickListPopupAction");
    }

    protected String getPopupTitle(AnActionEvent e) {
        return "Refactor This";
    }
}

