/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.inline.InlineRefactoringActionHandler;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineAction
extends BasePlatformRefactoringAction {
    public InlineAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        return InlineAction.hasInlineActionHandler(element, PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)element.getProject()), editor);
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/InlineAction", "isEnabledOnElements"));
        }
        return elements.length == 1 && InlineAction.hasInlineActionHandler(elements[0], null, null);
    }

    private static boolean hasInlineActionHandler(PsiElement element, @Nullable Language editorLanguage, Editor editor) {
        for (InlineActionHandler handler : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler.isEnabledOnElement(element, editor)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)(editorLanguage != null ? editorLanguage : element.getLanguage())).size() > 0;
    }

    @Override
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/InlineAction", "getRefactoringHandler"));
        }
        return new InlineRefactoringActionHandler();
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/InlineAction", "getHandler"));
        }
        RefactoringActionHandler handler = super.getHandler(language, element);
        if (handler != null) {
            return handler;
        }
        List handlers = InlineHandlers.getInlineHandlers((Language)language);
        return handlers.isEmpty() ? null : new InlineRefactoringActionHandler();
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        for (InlineActionHandler handler : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler.isEnabledForLanguage(language)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)language).size() > 0;
    }
}

