/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureAction
extends BaseRefactoringAction {
    public ChangeSignatureAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction", "isEnabledOnElements"));
        }
        return elements.length == 1 && ChangeSignatureAction.findTargetMember(elements[0]) != null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        PsiElement targetMember = ChangeSignatureAction.findTargetMember(file, editor);
        if (targetMember == null) {
            ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(file.getLanguage());
            return targetHandler != null;
        }
        ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
        return targetHandler != null;
    }

    @Nullable
    private static PsiElement findTargetMember(PsiFile file, Editor editor) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement targetMember = ChangeSignatureAction.findTargetMember(element);
        if (targetMember != null) {
            return targetMember;
        }
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (reference == null) {
            return null;
        }
        return reference.resolve();
    }

    @Nullable
    private static PsiElement findTargetMember(@Nullable PsiElement element) {
        PsiElement targetMember;
        if (element == null) {
            return null;
        }
        ChangeSignatureHandler fileHandler = ChangeSignatureAction.getChangeSignatureHandler(element.getLanguage());
        if (fileHandler != null && (targetMember = fileHandler.findTargetMember(element)) != null) {
            return targetMember;
        }
        PsiReference reference = element.getReference();
        if (reference == null && element instanceof PsiNameIdentifierOwner) {
            return element;
        }
        if (reference != null) {
            return reference.resolve();
        }
        return null;
    }

    @Override
    protected boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        PsiElement targetMember;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction", "hasAvailableHandler"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return false;
            }
            targetMember = ChangeSignatureAction.findTargetMember(file, editor);
        } else {
            PsiElement[] elements = ChangeSignatureAction.getPsiElementArray(dataContext);
            if (elements.length != 1) {
                return false;
            }
            targetMember = ChangeSignatureAction.findTargetMember(elements[0]);
        }
        return targetMember != null && ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage()) != null;
    }

    @Override
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        PsiElement psiElement;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction", "getHandler"));
        }
        Language language = (Language)LangDataKeys.LANGUAGE.getData(dataContext);
        if (language == null && (psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null) {
            language = psiElement.getLanguage();
        }
        if (language != null) {
            return new RefactoringActionHandler(){

                public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                    }
                    editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    PsiElement targetMember = ChangeSignatureAction.findTargetMember(file, editor);
                    if (targetMember == null) {
                        String notFoundMessage;
                        ChangeSignatureHandler handler = ChangeSignatureAction.getChangeSignatureHandler(file.getLanguage());
                        if (handler != null && (notFoundMessage = handler.getTargetNotFoundMessage()) != null) {
                            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)notFoundMessage, (String)ChangeSignatureHandler.REFACTORING_NAME, null);
                        }
                        return;
                    }
                    ChangeSignatureHandler handler = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                    if (handler == null) {
                        return;
                    }
                    handler.invoke(project, new PsiElement[]{targetMember}, dataContext);
                }

                public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                    }
                    if (elements == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                    }
                    if (elements.length != 1) {
                        return;
                    }
                    PsiElement targetMember = ChangeSignatureAction.findTargetMember(elements[0]);
                    if (targetMember == null) {
                        return;
                    }
                    ChangeSignatureHandler handler = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                    if (handler == null) {
                        return;
                    }
                    handler.invoke(project, new PsiElement[]{targetMember}, dataContext);
                }
            };
        }
        return null;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return ChangeSignatureAction.getChangeSignatureHandler(language) != null;
    }

    @Nullable
    private static ChangeSignatureHandler getChangeSignatureHandler(Language language) {
        return ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(language)).getChangeSignatureHandler();
    }
}

