/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SdkOrLibraryWeigher
extends ProximityWeigher {
    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/proximity/SdkOrLibraryWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/proximity/SdkOrLibraryWeigher", "weigh"));
        }
        Project project = location.getProject();
        return project == null ? null : Boolean.valueOf(SdkOrLibraryWeigher.isJdkElement(element, project));
    }

    static boolean isJdkElement(PsiElement element, @NotNull Project project) {
        List orderEntries;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/proximity/SdkOrLibraryWeigher", "isJdkElement"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && !(orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file)).isEmpty() && orderEntries.get(0) instanceof JdkOrderEntry;
    }
}

