/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;

public class SameDirectoryWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiDirectory, ProximityLocation> PLACE_DIRECTORY = NullableLazyKey.create((String)"placeDirectory", (NullableFunction)new NullableFunction<ProximityLocation, PsiDirectory>(){

        public PsiDirectory fun(ProximityLocation location) {
            return SameDirectoryWeigher.getParentDirectory(location.getPosition());
        }
    });

    private static PsiDirectory getParentDirectory(PsiElement element) {
        PsiFile file = InjectedLanguageUtil.getTopLevelFile(element);
        if (file != null) {
            element = file;
        }
        while (element != null && !(element instanceof PsiDirectory)) {
            element = element.getParent();
        }
        return (PsiDirectory)element;
    }

    @Override
    public Boolean weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/proximity/SameDirectoryWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/proximity/SameDirectoryWeigher", "weigh"));
        }
        if (location.getPosition() == null) {
            return Boolean.TRUE;
        }
        PsiDirectory placeDirectory = (PsiDirectory)PLACE_DIRECTORY.getValue((UserDataHolder)location);
        return placeDirectory != null && placeDirectory.equals(SameDirectoryWeigher.getParentDirectory(element));
    }
}

