/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitlyImportedWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiPackage, ProximityLocation> PLACE_PACKAGE = NullableLazyKey.create((String)"placePackage", (NullableFunction)new NullableFunction<ProximityLocation, PsiPackage>(){

        public PsiPackage fun(ProximityLocation location) {
            PsiElement position = location.getPosition();
            if (position == null) {
                return null;
            }
            return ExplicitlyImportedWeigher.getContextPackage(position);
        }
    });

    @Nullable
    private static PsiPackage getContextPackage(PsiElement position) {
        PsiFile file = position.getContainingFile();
        if (file == null) {
            return null;
        }
        PsiFile originalFile = file.getOriginalFile();
        while (true) {
            PsiElement context;
            if ((context = originalFile.getContext()) == null) {
                PsiDirectory parent = originalFile.getParent();
                if (parent != null) {
                    return JavaDirectoryService.getInstance().getPackage(parent);
                }
                return null;
            }
            PsiFile containingFile = context.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            originalFile = containingFile.getOriginalFile();
        }
    }

    @Override
    public Integer weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiPackage placePackage;
        PsiJavaFile psiJavaFile;
        String qname;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher", "weigh"));
        }
        PsiElement position = location.getPosition();
        if (position == null) {
            return 0;
        }
        PsiUtilCore.ensureValid((PsiElement)position);
        PsiFile elementFile = element.getContainingFile();
        PsiFile positionFile = position.getContainingFile();
        if (positionFile != null && elementFile != null && positionFile.getOriginalFile().equals(elementFile.getOriginalFile())) {
            return 3;
        }
        if (element instanceof PsiClass && (qname = ((PsiClass)element).getQualifiedName()) != null && (psiJavaFile = (PsiJavaFile)PsiTreeUtil.getContextOfType((PsiElement)position, PsiJavaFile.class, (boolean)false)) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiJavaFile);
            PsiImportList importList = psiJavaFile.getImportList();
            if (importList != null) {
                for (PsiImportStatement importStatement : importList.getImportStatements()) {
                    boolean onDemand = importStatement.isOnDemand();
                    String imported = importStatement.getQualifiedName();
                    if ((!onDemand || !qname.startsWith(imported + ".")) && (onDemand || !qname.equals(imported))) continue;
                    return 1;
                }
            }
        }
        if (element instanceof PsiMember && (placePackage = (PsiPackage)PLACE_PACKAGE.getValue((UserDataHolder)location)) != null) {
            Module elementModule = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (location.getPositionModule() == elementModule && placePackage.equals(ExplicitlyImportedWeigher.getContextPackage(element))) {
                return 2;
            }
        }
        return 0;
    }
}

