/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguagePatterns", storages={@Storage(file="$APP_CONFIG$/templateLanguages.xml")})
public class TemplateDataLanguagePatterns
implements PersistentStateComponent<Element> {
    private FileTypeAssocTable<Language> myAssocTable = new FileTypeAssocTable();
    @NonNls
    private static final String SEPARATOR = ";";

    public static TemplateDataLanguagePatterns getInstance() {
        return (TemplateDataLanguagePatterns)ServiceManager.getService(TemplateDataLanguagePatterns.class);
    }

    public FileTypeAssocTable<Language> getAssocTable() {
        return this.myAssocTable.copy();
    }

    @Nullable
    public Language getTemplateDataLanguageByFileName(VirtualFile file) {
        return this.myAssocTable.findAssociatedFileType(file.getName());
    }

    public void setAssocTable(FileTypeAssocTable<Language> assocTable) {
        this.myAssocTable = assocTable.copy();
    }

    public void loadState(Element state) {
        this.myAssocTable = new FileTypeAssocTable();
        THashMap dialectMap = new THashMap();
        for (Language dialect : TemplateDataLanguageMappings.getTemplateableLanguages()) {
            dialectMap.put((Object)dialect.getID(), (Object)dialect);
        }
        List files = state.getChildren("pattern");
        for (Element fileElement : files) {
            String patterns = fileElement.getAttributeValue("value");
            String langId = fileElement.getAttributeValue("lang");
            Language dialect = (Language)dialectMap.get((Object)langId);
            if (dialect == null || StringUtil.isEmpty((String)patterns)) continue;
            for (String pattern : patterns.split(SEPARATOR)) {
                this.myAssocTable.addAssociation(FileTypeManager.parseFromString((String)pattern), dialect);
            }
        }
    }

    public Element getState() {
        Element state = new Element("x");
        for (Language language : TemplateDataLanguageMappings.getTemplateableLanguages()) {
            List<FileNameMatcher> matchers = this.myAssocTable.getAssociations(language);
            if (matchers.isEmpty()) continue;
            Element child = new Element("pattern");
            state.addContent(child);
            child.setAttribute("value", StringUtil.join(matchers, (Function)new Function<FileNameMatcher, String>(){

                public String fun(FileNameMatcher fileNameMatcher) {
                    return fileNameMatcher.getPresentableString();
                }
            }, (String)SEPARATOR));
            child.setAttribute("lang", language.getID());
        }
        return state;
    }
}

