/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodResolveProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint {
    private final String myNameHint;
    private final List<PsiMethod> myMethods = new ArrayList<PsiMethod>();

    public MethodResolveProcessor() {
        this.myNameHint = null;
    }

    public MethodResolveProcessor(String name) {
        this.myNameHint = name;
    }

    public PsiMethod[] getMethods() {
        return this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
    }

    public boolean execute(@NotNull PsiElement element, ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/MethodResolveProcessor", "execute"));
        }
        if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull(this.myMethods, (Object)((PsiMethod)element));
        }
        return true;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/MethodResolveProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == NameHint.KEY && this.myNameHint != null) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    public static PsiMethod[] findMethod(PsiClass psiClass, String methodName) {
        MethodResolveProcessor processor = new MethodResolveProcessor(methodName);
        psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        return processor.getMethods();
    }

    public static PsiMethod[] getAllMethods(PsiClass psiClass) {
        MethodResolveProcessor processor = new MethodResolveProcessor();
        psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        return processor.getMethods();
    }

    @Override
    @Nullable
    public String getName(ResolveState state) {
        return this.myNameHint;
    }
}

