/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiElementProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilterElementProcessor
implements PsiElementProcessor {
    private final List<PsiElement> myResults;
    private final ElementFilter myFilter;
    private final PsiElementProcessor myProcessor;

    public FilterElementProcessor(ElementFilter filter, PsiElementProcessor processor, List container) {
        this.myFilter = filter;
        this.myProcessor = processor;
        this.myResults = container;
    }

    public FilterElementProcessor(ElementFilter filter, List container) {
        this(filter, null, container);
    }

    public FilterElementProcessor(ElementFilter filter, PsiElementProcessor proc) {
        this(filter, proc, new ArrayList());
    }

    public FilterElementProcessor(ElementFilter filter) {
        this(filter, null, new ArrayList());
    }

    public boolean execute(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/FilterElementProcessor", "execute"));
        }
        if (this.myFilter.isClassAcceptable(element.getClass()) && this.myFilter.isAcceptable((Object)element, element.getParent())) {
            if (this.myProcessor != null) {
                return this.myProcessor.execute(element);
            }
            this.add(element);
        }
        return true;
    }

    protected void add(PsiElement element) {
        this.myResults.add(element);
    }

    public List<PsiElement> getResults() {
        return this.myResults;
    }

    public boolean shouldProcess(Class elementClass) {
        return this.myFilter.isClassAcceptable(elementClass);
    }
}

