/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentGroup;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;

public class XmlElementContentSpecImpl
extends XmlElementImpl
implements XmlElementContentSpec,
XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlElementContentSpecImpl");

    public XmlElementContentSpecImpl() {
        super(XML_ELEMENT_CONTENT_SPEC);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XML_CONTENT_ANY) {
            return 231;
        }
        if (i == XML_CONTENT_EMPTY) {
            return 232;
        }
        if (i == XML_PCDATA) {
            return 233;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.findElementByTokenType(XML_CONTENT_EMPTY) != null;
    }

    public boolean isAny() {
        return this.findElementByTokenType(XML_CONTENT_ANY) != null;
    }

    public boolean isMixed() {
        XmlElementContentGroup topGroup = this.getTopGroup();
        return topGroup != null && ((XmlElementImpl)topGroup).findElementByTokenType(XML_PCDATA) != null;
    }

    public boolean hasChildren() {
        return !this.isEmpty() && !this.isAny() && !this.isMixed();
    }

    public XmlElementContentGroup getTopGroup() {
        return (XmlElementContentGroup)this.findElementByTokenType(XML_ELEMENT_CONTENT_GROUP);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, XmlElementContentSpec.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlElementContentSpecImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/xml/XmlElementContentSpecImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlElement((XmlElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

