/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.IdentitySmartPointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredImpl
implements PsiLanguageInjectionHost.Shred {
    private final RangeMarker relevantRangeInHost;
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer;
    private final TextRange range;
    private final String prefix;
    private final String suffix;

    ShredImpl(@NotNull PsiLanguageInjectionHost host, @NotNull PsiFile hostPsiFile, @NotNull RangeMarker relevantRangeInHost, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange range) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (relevantRangeInHost == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        this.hostElementPointer = ShredImpl.createHostSmartPointer(host, hostPsiFile);
        this.relevantRangeInHost = relevantRangeInHost;
        this.prefix = prefix;
        this.suffix = suffix;
        this.range = range;
        assert (this.isValid());
        assert (relevantRangeInHost.isValid());
    }

    public SmartPsiElementPointer<PsiLanguageInjectionHost> getSmartPointer() {
        return this.hostElementPointer;
    }

    @NotNull
    private static <T extends PsiLanguageInjectionHost> SmartPsiElementPointer<T> createHostSmartPointer(@NotNull T host, @NotNull PsiFile hostPsiFile) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "createHostSmartPointer"));
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "createHostSmartPointer"));
        }
        Object object = hostPsiFile.isPhysical() ? SmartPointerManager.getInstance((Project)hostPsiFile.getProject()).createSmartPsiElementPointer(host, hostPsiFile) : new IdentitySmartPointer(host, hostPsiFile);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "createHostSmartPointer"));
        }
        return object;
    }

    @Nullable(value="returns null when the host document marker is invalid")
    public Segment getHostRangeMarker() {
        RangeMarker marker = this.relevantRangeInHost;
        return marker.isValid() ? marker : null;
    }

    @NotNull
    public TextRange getRangeInsideHost() {
        ProperTextRange textRange;
        PsiLanguageInjectionHost host = this.getHost();
        ProperTextRange properTextRange = textRange = this.relevantRangeInHost.isValid() ? new ProperTextRange(this.relevantRangeInHost.getStartOffset(), this.relevantRangeInHost.getEndOffset()) : null;
        if (host == null) {
            if (textRange != null) {
                ProperTextRange properTextRange2 = textRange;
                if (properTextRange2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
                }
                return properTextRange2;
            }
            Segment fromSP = this.hostElementPointer.getRange();
            if (fromSP != null) {
                TextRange textRange2 = TextRange.create((Segment)fromSP);
                if (textRange2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
                }
                return textRange2;
            }
            TextRange textRange3 = new TextRange(0, 0);
            if (textRange3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
            }
            return textRange3;
        }
        TextRange hostTextRange = host.getTextRange();
        ProperTextRange properTextRange3 = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
        if (textRange == null) {
            ProperTextRange properTextRange4 = new ProperTextRange(0, hostTextRange.getLength());
            if (properTextRange4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
            }
            return properTextRange4;
        }
        ProperTextRange properTextRange5 = textRange.shiftRight(-hostTextRange.getStartOffset());
        if (properTextRange5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
        }
        return properTextRange5;
    }

    public String toString() {
        PsiLanguageInjectionHost host = this.getHost();
        return "Shred " + (host == null ? null : host.getTextRange()) + ": " + host + " In host range: " + (this.relevantRangeInHost.isValid() ? "" : "!") + "(" + this.relevantRangeInHost.getStartOffset() + "," + this.relevantRangeInHost.getEndOffset() + ");" + " PSI range: " + this.range;
    }

    public boolean isValid() {
        PsiLanguageInjectionHost host = this.getHost();
        return this.relevantRangeInHost.isValid() && host != null && host.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)o;
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRangeMarker = shred.getHostRangeMarker();
        return host != null && host.equals(shred.getHost()) && this.prefix.equals(shred.getPrefix()) && this.suffix.equals(shred.getSuffix()) && this.range.equals((Object)shred.getRange()) && hostRangeMarker != null && TextRange.create((Segment)this.relevantRangeInHost).equals((Object)TextRange.create((Segment)hostRangeMarker));
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public void dispose() {
        this.relevantRangeInHost.dispose();
    }

    @Nullable
    public PsiLanguageInjectionHost getHost() {
        return (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRange"));
        }
        return textRange;
    }

    @NotNull
    public String getPrefix() {
        String string = this.prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getPrefix"));
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getSuffix"));
        }
        return string;
    }
}

