/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedPsiCachedValueProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageUtil {
    static final Key<List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    public static Key<Boolean> FRANKENSTEIN_INJECTION = Key.create((String)"FRANKENSTEIN_INJECTION");
    private static final InjectedPsiCachedValueProvider INJECTED_PSI_PROVIDER = new InjectedPsiCachedValueProvider();
    private static final Key<ParameterizedCachedValue<MultiHostRegistrarImpl, PsiElement>> INJECTED_PSI = Key.create((String)"INJECTED_PSI");
    private static final Key<ConcurrentList<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");

    public static void forceInjectionOnElement(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "forceInjectionOnElement"));
        }
        InjectedLanguageUtil.enumerate(host, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$1", "visit"));
                }
            }
        });
    }

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "loadTree"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "loadTree"));
        }
        if (containingFile instanceof DummyHolder && (context = containingFile.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        PsiElement psiElement = host;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "loadTree"));
        }
        return psiElement;
    }

    public static List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> getHighlightTokens(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getHighlightTokens"));
        }
        return (List)file.getUserData(HIGHLIGHT_TOKENS);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getShreds"));
        }
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtil.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getShreds"));
        }
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return ((DocumentWindowImpl)myFileViewProvider.getDocument()).getShreds();
    }

    public static void enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "enumerate"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "enumerate"));
        }
        PsiFile containingFile = host.getContainingFile();
        InjectedLanguageUtil.enumerate(host, containingFile, true, visitor);
    }

    public static void enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        MultiHostRegistrarImpl registrar;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "enumerate"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "enumerate"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "enumerate"));
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (context == null) {
                return;
            }
            PsiFile file = context.getContainingFile();
            if (file == null || !file.isPhysical() && file.getOriginalFile() == file) {
                return;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return;
        }
        PsiElement inTree = InjectedLanguageUtil.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((registrar = InjectedLanguageUtil.probeElementsUp(host, containingFile, probeUp)) == null) {
            return;
        }
        List<Pair<Place, PsiFile>> places = registrar.getResult();
        for (Pair<Place, PsiFile> pair : places) {
            if (visitor instanceof InjectedReferenceVisitor) {
                if (registrar.getReferenceInjector() == null) continue;
                ((InjectedReferenceVisitor)visitor).visitInjectedReference(registrar.getReferenceInjector(), (List)pair.first);
                continue;
            }
            if (pair.second == null) continue;
            visitor.visit((PsiFile)pair.second, (List)pair.first);
        }
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file, offset);
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file, int offset) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
        }
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            Editor editor = hostEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
            }
            return editor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor = hostEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
            }
            return editor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        SelectionModel selectionModel = hostEditor.getSelectionModel();
        if (selectionModel.hasSelection() && (selstart = selectionModel.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, selectionModel.getSelectionEnd()))) {
            Editor editor = hostEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
            }
            return editor;
        }
        if (!documentWindow.isValid()) {
            Editor editor = hostEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
            }
            return editor;
        }
        Editor editor = EditorWindowImpl.create(documentWindow, (EditorImpl)hostEditor, injectedFile);
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedEditorForInjectedFile"));
        }
        return editor;
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findInjectedPsiNoCommit"));
        }
        PsiElement injected = InjectedLanguageUtil.findInjectedElementNoCommit(host, offset);
        return injected == null ? null : injected.getContainingFile();
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findElementAtNoCommit"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            result = InjectedLanguageUtil.tryOffset(file, offset, documentManager);
            PsiElement injected = (PsiElement)result.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result != null && baseLanguage == result.third) {
            return (PsiElement)result.second;
        }
        return viewProvider.findElementAt(offset, baseLanguage);
    }

    private static MultiHostRegistrarImpl probeElementsUp(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "probeElementsUp"));
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "probeElementsUp"));
        }
        PsiManager psiManager = hostPsiFile.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        if (injectedManager == null) {
            return null;
        }
        MultiHostRegistrarImpl registrar = null;
        PsiElement current = element;
        block0: while (current != null && current != hostPsiFile) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current.getLanguage().getID())) break;
            ParameterizedCachedValue data = (ParameterizedCachedValue)current.getUserData(INJECTED_PSI);
            registrar = data == null ? InjectedPsiCachedValueProvider.doCompute(current, injectedManager, project, hostPsiFile) : (MultiHostRegistrarImpl)data.getValue((Object)current);
            current = current.getParent();
            if (registrar != null) {
                List<Pair<Place, PsiFile>> places = registrar.getResult();
                TextRange elementRange = element.getTextRange();
                for (Pair<Place, PsiFile> pair : places) {
                    Place place = (Place)((Object)pair.first);
                    Iterator i$ = place.iterator();
                    while (i$.hasNext()) {
                        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                        if (!shred.getHost().getTextRange().intersects(elementRange) || !place.isValid()) continue;
                        break block0;
                    }
                }
            }
            if (probeUp) continue;
            break;
        }
        if (probeUp) {
            for (PsiElement e = element; e != current && e != null && e != hostPsiFile; e = e.getParent()) {
                ProgressManager.checkCanceled();
                if (registrar == null) {
                    e.putUserData(INJECTED_PSI, null);
                    continue;
                }
                ParameterizedCachedValue cachedValue = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)INJECTED_PSI_PROVIDER, false);
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)registrar, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, registrar});
                ((PsiParameterizedCachedValue)cachedValue).setValue(result);
                e.putUserData(INJECTED_PSI, (Object)cachedValue);
            }
        }
        return registrar;
    }

    public static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findInjectedElementNoCommit"));
        }
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project = hostFile.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Trinity<PsiElement, PsiElement, Language> result = InjectedLanguageUtil.tryOffset(hostFile, offset, documentManager);
        PsiElement injected = (PsiElement)result.first;
        return injected;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset, @NotNull PsiDocumentManager documentManager) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "tryOffset"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "tryOffset"));
        }
        FileViewProvider provider = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element = provider.findElementAt(offset, language);
            if (element != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element;
                }
                if ((injected2 = InjectedLanguageUtil.findInside(element, hostFile, offset, documentManager)) != null) {
                    Trinity trinity = Trinity.create((Object)injected2, (Object)element, (Object)language);
                    if (trinity == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "tryOffset"));
                    }
                    return trinity;
                }
            }
            if (offset == 0 || element != null && element.getTextRange().getStartOffset() != offset || (leftElement = provider.findElementAt(offset - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset || (injected = InjectedLanguageUtil.findInside(leftElement, hostFile, offset, documentManager)) == null) continue;
            Trinity trinity = Trinity.create((Object)injected, (Object)element, (Object)language);
            if (trinity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "tryOffset"));
            }
            return trinity;
        }
        Trinity trinity = Trinity.create(null, leafElement, leafLanguage);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "tryOffset"));
        }
        return trinity;
    }

    private static PsiElement findInside(@NotNull PsiElement element, @NotNull PsiFile hostFile, final int hostOffset, final @NotNull PsiDocumentManager documentManager) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findInside"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findInside"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findInside"));
        }
        final Ref out = new Ref();
        InjectedLanguageUtil.enumerate(element, hostFile, true, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$2", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$2", "visit"));
                }
                for (PsiLanguageInjectionHost.Shred place : places) {
                    TextRange hostRange = place.getHost().getTextRange();
                    if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                    DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                    if (document == null) {
                        return;
                    }
                    int injectedOffset = document.hostToInjected(hostOffset);
                    PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                    out.set(injElement == null ? injectedPsi : injElement);
                }
            }
        });
        return (PsiElement)out.get();
    }

    @NotNull
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getCachedInjectedDocuments"));
        }
        ConcurrentList injected = (ConcurrentList)hostPsiFile.getUserData(INJECTED_DOCS_KEY);
        if (injected == null) {
            injected = (ConcurrentList)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createConcurrentList());
        }
        ConcurrentList concurrentList = injected;
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getCachedInjectedDocuments"));
        }
        return concurrentList;
    }

    public static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "clearCachedInjectedFragmentsForFile"));
        }
        file.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches(@NotNull PsiFile injected, @NotNull DocumentWindowImpl documentWindow) {
        PsiFile hostFile;
        if (injected == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "clearCaches"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "clearCaches"));
        }
        VirtualFileWindowImpl virtualFile = (VirtualFileWindowImpl)injected.getVirtualFile();
        PsiManagerEx psiManagerEx = (PsiManagerEx)injected.getManager();
        if (psiManagerEx.getProject().isDisposed()) {
            return;
        }
        psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null);
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)injected.getProject()).getInjectionHost((PsiElement)injected);
        if (context != null) {
            hostFile = context.getContainingFile();
        } else {
            VirtualFile delegate = virtualFile.getDelegate();
            PsiFile psiFile = hostFile = delegate.isValid() ? psiManagerEx.findFile(delegate) : null;
        }
        if (hostFile != null) {
            Object object = PsiLock.LOCK;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(hostFile);
                for (int i = cachedInjectedDocuments.size() - 1; i >= 0; --i) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i);
                }
            }
        }
    }

    public static Editor openEditorFor(@NotNull PsiFile file, @NotNull Project project) {
        Editor editor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "openEditorFor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "openEditorFor"));
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            return EditorWindowImpl.create((DocumentWindowImpl)document, (EditorImpl)editor, file);
        }
        return editor;
    }

    public static PsiFile getTopLevelFile(@NotNull PsiElement element) {
        PsiLanguageInjectionHost host;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getTopLevelFile"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(containingFile);
        if (document instanceof DocumentWindow && (host = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getTopLevelEditor"));
        }
        Editor editor2 = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        if (editor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getTopLevelEditor"));
        }
        return editor2;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "isInInjectedLanguagePrefixSuffix"));
        }
        PsiFile injectedFile = element.getContainingFile();
        if (injectedFile == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element.getTextRange();
        List editables = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiablesLength = 0;
        for (TextRange editable : editables) {
            combinedEdiablesLength += editable.getLength();
        }
        return combinedEdiablesLength != elementRange.getLength();
    }

    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "hasInjections"));
        }
        if (!host.isPhysical()) {
            return false;
        }
        final Ref result = Ref.create((Object)false);
        InjectedLanguageUtil.enumerate((PsiElement)host, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$3", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$3", "visit"));
                }
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public static String getUnescapedText(PsiFile file, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file.getProject());
        if (manager.getInjectionHost((PsiElement)file) == null) {
            return file.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(PsiElement element) {
                if (element == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtil.getUnescapedLeafText(element, false));
                } else {
                    super.visitElement(element);
                }
            }
        });
        return sb.toString();
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element, boolean strict) {
        String unescaped = (String)element.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element.getFirstChild() == null) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getDocumentWindow"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)virtualFile).getDocumentWindow();
        }
        return null;
    }

    public static boolean isInjectableLanguage(Language language) {
        return LanguageUtil.isInjectableLanguage((Language)language);
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "getInjectedStart"));
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, final int offset) {
        if (injectionHost == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil", "findElementInInjected"));
        }
        final Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$5", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$5", "visit"));
                }
                ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places)));
            }
        });
        return (PsiElement)ref.get();
    }
}

