/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.AddXsiSchemaLocationForExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.IgnoreExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class URLReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<URLReference> {
    @Override
    public void registerFixes(@NotNull URLReference ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReferenceQuickFixProvider", "registerFixes"));
        }
        registrar.register((IntentionAction)new FetchExtResourceAction());
        registrar.register((IntentionAction)new ManuallySetupExtResourceAction());
        registrar.register((IntentionAction)new IgnoreExtResourceAction());
        PsiElement parentElement = ref.getElement().getParent();
        if (parentElement instanceof XmlAttribute && ((XmlAttribute)parentElement).isNamespaceDeclaration()) {
            registrar.register((IntentionAction)new AddXsiSchemaLocationForExtResourceAction());
        }
    }

    @Override
    @NotNull
    public Class<URLReference> getReferenceClass() {
        if (URLReference.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReferenceQuickFixProvider", "getReferenceClass"));
        }
        return URLReference.class;
    }
}

